/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


import com.arsdigita.bebop.event.FormProcessListener;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.FormData;

// logging
import org.apache.log4j.Logger;


/**
 * This process listener is used to test submission of persistent
 * forms created with the Form Builder administration UI. The listener
 * simply logs all parameters submitted by the form.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/TestProcessListener.java#8 $
 */
public class TestProcessListener implements FormProcessListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/TestProcessListener.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    // Logging
    private static final Logger s_log =
        Logger.getLogger(TestProcessListener.class);

    public void process(FormSectionEvent formEvent) {
        FormData formData = formEvent.getFormData();

        java.util.Iterator parameterIter = formData.keySet().iterator();
        while (parameterIter.hasNext()) {
            String parameter = (String)parameterIter.next();
            Object value = formData.get(parameter);

            value = value == null ? "" : value;

            s_log.debug("Form submitted parameter " + parameter +
                        " with value " + value.toString() +
                        " and class " + value.getClass().getName());
        }
    }
}
