/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


import com.arsdigita.bebop.parameters.EmailParameter;


// logging


/**
 * I am using this process listener to test how process listeners
 * can supply the Form Builder admin UI with information about what kind of
 * parameters that they are expecting.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/TestAttributeListener.java#9 $
 */
public class TestAttributeListener extends TestProcessListener
    implements AttributeMetaDataProvider {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/TestAttributeListener.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public AttributeMetaDataList getAttributeMetaData() {

        AttributeMetaDataList attributeList = new AttributeMetaDataList();

        // Email address - required email parameter
        EmailParameter emailParameter = new EmailParameter("emailAddress");
        AttributeType emailType = new AttributeType(emailParameter.getClass());
        AttributeMetaData emailAttribute = new AttributeMetaData("emailAddress",
                                                                 null,
                                                                 true,
                                                                 false,
                                                                 emailType);
        attributeList.add(emailAttribute);

        // Subject - required
        AttributeMetaData subjectAttribute = new AttributeMetaData("subject",
                                                                   true);

        attributeList.add(subjectAttribute);

        // Priority - multiple
        AttributeMetaData priorityAttribute = new AttributeMetaData("priority",
                                                                    false,
                                                                    true);

        attributeList.add(priorityAttribute);

        // Body - long text
        AttributeMetaData bodyAttribute = new AttributeMetaData("body");

        attributeList.add(bodyAttribute);

        return attributeList;
    }
}
