/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;

// All ACSObjects have a unique id
import java.math.BigDecimal;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.metadata.ObjectType;

// Every PersistentComponentFactory can create a Bebop Component
import com.arsdigita.bebop.Component;

// Thrown if the underlying DataObject with given id cannot be found
import com.arsdigita.domain.DataObjectNotFoundException;

// The class we are making persistent
import com.arsdigita.bebop.form.Option;


/**
 * This class is responsible for persisting Bebop Options. The Option
 * is saved with the save() method. To resurrect the Option, use the constructor
 * taking the id of the saved Option and then invoke createComponent().
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentOption.java#8 $
 *
 */
public class PersistentOption extends PersistentComponent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentOption.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * The fully qualified name of the underlying DataObject of this class.
     */
    public static final String BASE_DATA_OBJECT_TYPE =
        "com.arsdigita.formbuilder.Option";

    // *** Constructors -------------

    /**
     * Constructor that creates a new Option domain object that
     * can be saved to the database later on.
     */
    public PersistentOption() {
        this(BASE_DATA_OBJECT_TYPE);
    }

    public PersistentOption(String typeName) {
        super(typeName);
    }

    public PersistentOption(ObjectType type) {
        super(type);
    }

    public PersistentOption(DataObject obj) {
        super(obj);
    }

    /**
     * Constructor that retrieves an existing Option domain object
     * from the database.
     *
     * @param id The object id of the Option domain object to retrieve
     */
    public PersistentOption(BigDecimal id)
        throws DataObjectNotFoundException {

        this(new OID(BASE_DATA_OBJECT_TYPE, id));
    }

    /**
     * Extending classes can use this constructor to set the sub class
     * id and object type.
     */
    public PersistentOption(OID oID)
        throws DataObjectNotFoundException {

        super(oID);
    }

    public static PersistentOption create(String parameterValue,
                                          String label) {
        PersistentOption o = new PersistentOption();
        o.setup(parameterValue, label);
        return o;
    }


    protected void setup(String parameterValue,
                         String label) {
        setLabel(label);
        setParameterValue(parameterValue);
    }

    /**
     * Create the Label whose persistence is managed
     * by this domain object.
     */
    public Component createComponent() {

        Option option = new Option(getParameterValue(), getLabel());

        return option;
    }

    //*** Attribute Methods

    public void setParameterValue(String parameterValue) {
        set("parameterValue", parameterValue);
    }

    public String getParameterValue() {
        return (String)get("parameterValue");
    }

    public void setLabel(String label) {
        set("label", label);
    }

    public String getLabel() {
        return (String)get("label");
    }
}
