/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


/**
 * This class can generate a PersistentForm given an object implementing the
 * <code>AttributeMetaDataProvider</code> interface. Such a persistent form
 * can be used as a starting point for an administrator building a persistent form
 * for a certain process listener.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentFormGenerator.java#7 $
 *
 */
public class PersistentFormGenerator {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentFormGenerator.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private AttributeMetaDataProvider m_metaDataProvider;

    public PersistentFormGenerator(AttributeMetaDataProvider metaDataProvider) {

        m_metaDataProvider = metaDataProvider;
    }

    public PersistentForm generatePersistentForm() {

        // TODO
        return PersistentForm.create("dummy form");
    }
}
