/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


// Each factory has a unique id by which it can be retrievd
import java.math.BigDecimal;

// The factory creates Bebop Components
import com.arsdigita.bebop.Component;


/**
 * Implemented by classes that can persist and create a Bebop
 * Component.
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentComponentFactory.java#8 $
 *
 */
public interface PersistentComponentFactory {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/PersistentComponentFactory.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Using the metadata in this persistent component
     * create a Bebop component that is a snapshot of
     * this data.
     */
    public Component createComponent();

    public void save();

    public void delete();

    public BigDecimal getID();

    /**
     * Indicates if the factory has been saved or not. See
     * {@link com.arsdigita.domain.DomainObject#isNew()}
     */
    public boolean isNew();
}
