/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.FormSection;

import com.arsdigita.formbuilder.PersistentComponentFactory;


/**
 * Implement this interface to add modifications to the persistent form
 * before each component gets added to the form. This does not work recursively
 * so that the observer is only executed in the top level PersistentFormSection.
 */
public interface ComponentAddObserver {

    public void beforeAddingComponent(FormSection formSection,
                                      PersistentComponentFactory componentFactory,
                                      int componentPosition);

    public void addingComponent(PersistentComponentFactory componentFactory,
                                int componentPosition,
                                Component component);

    public void afterAddingComponent(FormSection formSection,
                                     PersistentComponentFactory componentFactory,
                                     int componentPosition);
}
