/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.formbuilder;


/**
 * This interface should be implemented by classes implementing the
 * <code>FormProcessListener</code> that are used by persistent forms. The attribute
 * metadata provided serves a number of purposes when building a PersistentForm:
 *
 * <ul>
 *
 * <li>We can ensure that the PersistentForm submits the parameters that the process listener
 expects</li>
 *
 * <li> We can generate a default form that can be customized and persisted with the Form Builder admin UI.
 *      We thus avoid that the administrator having to build the persistent form scratch.</li>
 *
 * </ul>
 *
 * @author Peter Marklund
 * @version $Id: //core-platform/dev/src/com/arsdigita/formbuilder/AttributeMetaDataProvider.java#7 $
 *
 */
public interface AttributeMetaDataProvider {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/formbuilder/AttributeMetaDataProvider.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public AttributeMetaDataList getAttributeMetaData();
}
