/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import org.apache.log4j.Logger;

/**
 * InstantiatorRegistryException
 *
 * An unchecked exception thrown when there is an error registering a
 * DomainObjectInstantiator.
 *
 * @author <a href="mailto:jorris@redhat.com">Jon Orris</a>
 *
 */
public class InstantiatorRegistryException extends RuntimeException {
    private static Logger s_log = Logger.getLogger(InstantiatorRegistryException.class);

    /**
     * Constructs exception
     *
     * @param typeName - Name of the ObjectType
     * @param instantiator - The instantiator that was being registered.
     */
    public InstantiatorRegistryException(String typeName, DomainObjectInstantiator instantiator) {
        super(buildMessage(typeName, instantiator));
    }


    /**
     * Creates the error message, and sends to the system log.
     *
     * @param typeName - Name of the ObjectType
     * @param instantiator - The instantiator that was being registered.
     *
     * @return error message
     */
    private static String buildMessage(String typeName, DomainObjectInstantiator instantiator) {
        String msg = "Registering non existent ObjectType " +
                              typeName + " against instantiator " +
                              instantiator.getClass().toString();
        msg += System.getProperty("line.separator");
        msg += "Possible causes are a missing PDL file, or an incorrect BASE_DATA_OBJECT_TYPE";

        s_log.error(msg);
        return msg;
    }
}
