/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.domain;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * The GlobalObserverManager class is a singleton class that allows observers
 * implementing the GlobalObserver interface to be registered. Once such
 * observers are registered they have the opportunity to observe every single
 * observable domain object that is created. The
 * GlobalObserver.shouldObserve(DomainObject) method can be used by an
 * observer to select which objects to observe.
 *
 * @author <a href="mailto:rhs@mit.edu">rhs@mit.edu</a>
 * @version $Revision: #7 $ $Date: 2004/04/07 $
 **/

public class GlobalObserverManager {

    public final static String versionId = "$Id: //core-platform/dev/src/com/arsdigita/domain/GlobalObserverManager.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private static final GlobalObserverManager s_manager =
        new GlobalObserverManager();


    /**
     * Returns the global observer manager. This is a singleton class that
     * allows the "global" observers, or observers of any
     **/

    public static final GlobalObserverManager getManager() {
        return s_manager;
    }

    private List m_observers = new ArrayList();

    private GlobalObserverManager() {}


    /**
     * Adds a new observer.
     *
     * @param doo the new observer
     **/

    public void addObserver(GlobalObserver go) {
        m_observers.add(go);
    }


    /**
     * Returns the global observers.
     *
     * @return The observers for the given domain object.
     **/

    Iterator getObservers() {
        return m_observers.iterator();
    }

}
