/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.categorization;

import com.arsdigita.kernel.ACSObject;
import com.arsdigita.kernel.ACSObjectCollection;
import com.arsdigita.persistence.DataCollection;

/**
 * Represents a collection of categories.
 *
 * <p>Instances of this class are produced by various methods in {@link
 * Category} and other classes. See, for example, {@link Category#getChildren()}
 * or {@link Category#getDescendants()}.</p>
 *
 * @author Randy Graebner (randyg@alum.mit.edu)
 * @version $Revision: #14 $ $DateTime: 2004/04/07 16:07:11 $
 **/
public class CategoryCollection extends ACSObjectCollection {

    public CategoryCollection(DataCollection dataCollection) {
        super(dataCollection);
    }

    /**
     * Returns the name of the category.
     *
     * @return the category name.
     * @see Category#getName()
     */
    public String getName() {
        return (String) m_dataCollection.get("name");
    }

    /**
     * Returns the description.
     *
     * @return the description
     * @see Category#getDescription()
     */
    public String getDescription() {
        return (String) m_dataCollection.get("description");
    }

    /**
     *  Determines the current state of the category.
     *
     *  @return <code>true</code> if the category is enabled; <code>false</code>
     *  otherwise.
     * @see Category#isEnabled()
     */
    public boolean isEnabled() {
        return ((Boolean) m_dataCollection.get("isEnabled")).booleanValue();
    }

    /**
     * Wrapper to <code>getDomainObject()</code> that casts the returned
     * <code>DomainObject</code> as a <code>Category</code>.
     *
     * @return a <code>Category</code> for the current position in the
     * collection.
     **/
    public Category getCategory() {
        return (Category) getDomainObject();
    }

    public ACSObject getACSObject() {
        return getCategory();
    }

    /**
     * Sorts the category collection by the category sort key.
     *
     * @see CategorizedCollection#sort(boolean)
     **/
    public final void sort(boolean ascending) {
        if ( ascending ) {
            addOrder("link.sortKey asc");
        } else {
            addOrder("link.sortKey desc");
        }
    }
}
