/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.tree;

import com.arsdigita.bebop.PageState;
import java.util.Collections;
import java.util.Iterator;


/**
 *  The basic
 * implementation of the TreeModel interface.
 *
 * @author David Lutterkort 
 * @author Stanislav Freidin 
 * @author Tri Tran 
 *
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/tree/DefaultTreeModel.java#10 $ */
public class DefaultTreeModel implements TreeModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/tree/DefaultTreeModel.java#10 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private TreeNode rootTreeNode;
    private boolean _hasChildren;

    /**
     * Obtain the root node of the tree
     */
    public final TreeNode getRoot(PageState data) {
        return rootTreeNode;
    }

    /**
     * Check whether the node has children
     * @return true if this node has children (not leaf)
     */
    public final boolean hasChildren(TreeNode n, PageState data) {
        return _hasChildren;
    }

    /**
     * Check whether a given node has children
     */
    public Iterator getChildren(TreeNode n, PageState data) {
        return Collections.EMPTY_LIST.iterator();
    }
}
