/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.table;

import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Table;
import com.arsdigita.util.Lockable;

/**
 * Builds the request-specific table models. A table retrieves the data it
 * displays by asking the table model builder for a table model. This is
 * done for each request; the table does not cahce table models across
 * requests. If such caching is desired, it has to be performed by the
 * table model builder.
 *
 * <p> Typically, the table model builder will run a database query based
 * on the information contained in the page state and return the result of
 * the database query by wrapping it in a table model. The table will then
 * traverse the table model during rendering.
 *
 * <p> The table model builder is automatically locked by the table to
 * which it was added either through one of the {@link
 * com.arsdigita.bebop.Table Table} constructors or with a call to {@link
 * com.arsdigita.bebop.Table#setModelBuilder}.
 *
 * @see com.arsdigita.bebop.Table Table
 * @see TableModel
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/table/TableModelBuilder.java#7 $
 */
public interface TableModelBuilder extends Lockable {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/table/TableModelBuilder.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Return a table model for the request represented by
     * <code>s</code>. The table model contains all the data that is to be
     * displayed in a table. The returned table model is used only during
     * the duration of that request.
     *
     * @param t the table which will use this table model
     * @param s represents the current request
     * @return the data to be displayed in the table
     * @pre t != null
     * @pre s != null
     * @post return != null
     */
    TableModel makeModel(Table t, PageState s);
}
