/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.portal;

import java.util.Iterator;

/**
 *  <p>Defines a model for
 * use by Portal.  Portal builds and uses a PortalModel inside its
 * {@link Portal#generateXML} method.</p>
 *
 * @see Portal
 * @see PortalModelBuilder
 * @see PortletRenderer
 * @see AbstractPortletRenderer
 * @author Justin Ross
 * @author James Parsons
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/portal/PortalModel.java#6 $
 */
public interface PortalModel {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/portal/PortalModel.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Get the {@link Portlet}s of this PortalModel.  Users of the
     * {@link Portal} component are meant to implement this method for
     * their particular data source.
     *
     * @return an Iterator over the set of Portlets.
     * @post return != null
     */
    Iterator getPortletRenderers();

    /**
     * Get the title of this Portal.
     *
     * @return the title.
     * @post return != null
     */
    String getTitle();
}
