/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.bebop.event.ParameterListener;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.parameters.ParameterData;
import java.net.MalformedURLException;
import java.net.URL;



public class URLValidationListener implements ParameterListener {

    public void validate(ParameterEvent e)
        throws FormProcessException {

        ParameterData d = e.getParameterData();
        String value = (String)d.getValue();

        try {
            new URL(value);
        } catch (MalformedURLException ex) {
            d.invalidate();
            d.addError("Please enter a URL");
        }
    }
}
