/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import javax.servlet.http.HttpServletRequest;

/**
 *    A class that represents the model for String form parameters.
 *    This class extends StringParameter and differs by calling trim()
 *    on non-null values. This class is useful for fields you want to
 *    put in the DB without leading and trailng spaces
 *
 *    @author Karl Goldstein 
 *    @author Uday Mathur 
 *    @version $Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/TrimmedStringParameter.java#7 $ */
public class TrimmedStringParameter extends StringParameter {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/TrimmedStringParameter.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public TrimmedStringParameter(String name) {
        super(name);
    }

    public Object transformValue(HttpServletRequest request)
        throws IllegalArgumentException {

        String requestValue = (String)super.transformValue(request);
        if (requestValue!=null) {
            requestValue = requestValue.trim();
        }
        return (requestValue==null) ? null : unmarshal(requestValue);
    }
}
