/*
 * Copyright (C) 2002-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.parameters.ParameterData;
import com.arsdigita.bebop.event.ParameterEvent;
import com.arsdigita.globalization.GlobalizedMessage;

/**
 *  Verifies that the
 * parameter's value contains only letters and/or digits.
 *
 * @author Dennis Gregorovic 
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 **/

public class StringIsLettersOrDigitsValidationListener extends GlobalizedParameterListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/StringIsLettersOrDigitsValidationListener.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public StringIsLettersOrDigitsValidationListener(String title) {
        setError(new GlobalizedMessage(title, getBundleBaseName()));
    }

    public StringIsLettersOrDigitsValidationListener() {
        setError(new GlobalizedMessage(
                                       "parameter.only.letters.digits", getBundleBaseName()
                                       ));
    }

    public StringIsLettersOrDigitsValidationListener(GlobalizedMessage error) {
        setError(error);
    }

    public void validate (ParameterEvent e) throws FormProcessException {
        ParameterData data = e.getParameterData();
        Object obj = data.getValue();

        if (obj == null) {
            return;
        }

        String value;
        try {
            value = (String) obj;
        } catch (ClassCastException cce) {
            throw new FormProcessException (cce.getMessage());
        }

        for (int i = 0; i < value.length(); i++) {
            char c = value.charAt(i);
            if (!Character.isLetterOrDigit(c)) {
                data.addError(getError());
                return;
            }
        }
    }
}
