/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.parameters;

import javax.servlet.http.HttpServletRequest;
import java.math.BigDecimal;

/**
 * A class which represents a BigDecimal
 */
public class BigDecimalParameter extends ParameterModel {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/parameters/BigDecimalParameter.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public BigDecimalParameter(String name) {
        super(name);
    }

    public Object transformValue(HttpServletRequest request)
        throws IllegalArgumentException {
        return transformSingleValue(request);
    }

    public Object unmarshal(String encoded)
        throws IllegalArgumentException {

        if (encoded == null || encoded.length() == 0) {
            return null;
        }
        try {
            return new BigDecimal(encoded);
        } catch (NumberFormatException e) {
            e.printStackTrace();
            throw new IllegalArgumentException
                (getName() + " should be a BigDecimal: '" + encoded + "'");
        }
    }

    public Class getValueClass() {
        return BigDecimal.class;
    }

}
