/*
 * Copyright (C) 2003-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.page;

import com.arsdigita.bebop.Page;
import com.arsdigita.templating.Templating;
import com.arsdigita.templating.PresentationManager;
import com.arsdigita.xml.Document;
import com.arsdigita.web.BaseApplicationServlet;
import com.arsdigita.web.Application;
import com.arsdigita.util.Assert;
import com.arsdigita.developersupport.DeveloperSupport;
import java.io.IOException;

import java.util.Map;
import java.util.HashMap;

import javax.servlet.ServletException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.log4j.Logger;

/**
 * @author Justin Ross &lt;jross@redhat.com&gt;
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/page/BebopApplicationServlet.java#7 $
 */
public class BebopApplicationServlet extends BaseApplicationServlet {
    public static final String versionId =
        "$Id: //core-platform/dev/src/com/arsdigita/bebop/page/BebopApplicationServlet.java#7 $" +
        "$Author: dennis $" +
        "$DateTime: 2004/04/07 16:07:11 $";

    private static final Logger s_log = Logger.getLogger
        (BebopApplicationServlet.class);

    // String pathInfo => Page page
    private final Map m_pages = new HashMap();

    public void init() throws ServletException {
        super.init();
    }

    protected final void put(final String pathInfo,
                             final Page page) {
        Assert.exists(pathInfo, String.class);
        Assert.exists(page, Page.class);
        Assert.truth(pathInfo.startsWith("/"), "path starts with '/'");

        m_pages.put(pathInfo, page);
    }

    protected final void doService(final HttpServletRequest sreq,
                                   final HttpServletResponse sresp,
                                   final Application app)
            throws ServletException, IOException {
        final String pathInfo = sreq.getPathInfo();

        Assert.assertNotNull(pathInfo, "String pathInfo");

        final Page page = (Page) m_pages.get(pathInfo);

        if (page == null) {
            sresp.sendError(404, "Application not found");
            throw new IllegalStateException("No such page for path " + pathInfo);
        } else {
            DeveloperSupport.startStage("Dispatcher page.buildDocument");
            final Document doc = page.buildDocument(sreq, sresp);
            DeveloperSupport.endStage("Dispatcher page.buildDocument");


            DeveloperSupport.startStage("Dispatcher presMgr.servePage");
            PresentationManager pm = Templating.getPresentationManager();
            pm.servePage(doc, sreq, sresp);
            DeveloperSupport.endStage("Dispatcher presMgr.servePage");
        }
    }
}
