/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

/**
 * JSP tag handler to iterate over rows in a model-backed Table body.
 * @see com.arsdigita.bebop.jsp.ShowTable
 */

public class ShowTableBody extends ShowCellList {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/ShowTableBody.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Returns a TreeWalker to pick out rows in the bebop:tbody
     * section of this table.
     */
    protected TreeWalker makeTreeWalker() {
        // walker will walk over columns in header
        // allowing each to be styled dynamically'
        // (man I should be using XPath here.)
        // select="./bebop:tbody/bebop:trow"
        TreeWalker tw = createTreeWalker(getInputContext(), new NodeFilter() {
                public short acceptNode(Node n) {
                    if (n.getNodeName().equals("bebop:trow")) {
                        return FILTER_ACCEPT;
                    } else if (n.getNodeName().equals("bebop:tbody")) {
                        return FILTER_SKIP;
                    } else if (n instanceof Element) {
                        return FILTER_REJECT;
                    } else {
                        return FILTER_SKIP;
                    }
                }
            });
        return tw;
    }
}
