/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.TabbedPane;
import javax.servlet.jsp.JspException;

/**
 * Class for defining a single component tab within a define:tabbedPane
 * JSP tag.  This is an odd tag becuase it doesn't really define a
 * real Bebop container; rather it's a "virtual" container that exists only
 * inside the tag handler class as a way of associating a label with
 * the tag.  The define:tab tag is a special case because we have to
 * call <code>addTab(String label, Component)</code> to add tabs to the
 * tabbed pane, not just<code>add(Component)</code>.
 */
public class DefineTab extends DefineContainer {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefineTab.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Component m_child;
    private String m_label;

    private final static String ERROR_MESSAGE =
        "define:tab must be contained within define:tabbedPane.";

    /**
     * doStartTag() is a special case that does nothing.
     */
    public int doStartTag() throws JspException {
        // don't add anything to parent just yet
        return EVAL_BODY_TAG;
    }

    /**
     * At the close of the tag, add the component <em>within</em> this
     * tag to the tabbed pane with the specified label.
     */
    public int doEndTag() throws JspException {
        // now add to parent
        try {
            TabbedPane parent = (TabbedPane)getParentTag().getComponent();
            parent.addTab(m_label, m_child);
        } catch (ClassCastException cce) {
            throw new JspException(ERROR_MESSAGE);
        }
        return super.doEndTag();
    }

    /**
     * overrides the default container method.  This tag is a placeholder,
     * so we just keep track of what the "real" component contained within
     * this tab is so we can add it to the tabbed pane later on.
     */
    public final void addComponent(Component c) {
        m_child = c;
    }

    protected final Component getComponent() {
        return m_child;
    }

    /**
     * sets the label for the tab contained within this tag.
     */
    public final void setLabel(String l) {
        m_label = l;
    }
}
