/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.jsp;

import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.form.Password;
import javax.servlet.jsp.JspException;

public class DefinePassword extends DefineComponent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/jsp/DefinePassword.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private Password m_password;
    private int m_maxLength;
    private int m_size;

    public int doStartTag() throws JspException {
        m_password = new Password(getName());
        m_password.setSize(m_size);
        m_password.setMaxLength(m_maxLength);
        // add form to parent
        int ret = super.doStartTag();
        // must put parameter model in page context after calling supereclass
        pageContext.setAttribute(getName(), m_password.getParameterModel());
        return ret;
    }

    protected final Component getComponent() {
        return m_password;
    }

    public final void setSize(String s) {
        m_size = new Integer(s).intValue();
    }

    public final void setMaxLength(String s) {
        m_maxLength = new Integer(s).intValue();
    }
}
