/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.event;

import com.arsdigita.bebop.FormProcessException;
import java.util.EventListener;

/**
 * Defines the interface for initializing a form with default values.
 * Typical implementations of this interface query the database to
 * set up an "edit" form, or obtain an id from a sequence to initialize
 * a "create" form.
 *
 * @author Karl Goldstein 
 * @author Uday Mathur 
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormInitListener.java#7 $
 */

public interface FormInitListener extends EventListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/event/FormInitListener.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    /**
     * Initializes a FormData object already populated with values from
     * the request.
     *
     * @param date The form data containing data included with this
     * request.  The initializer may require knowledge of form or
     * parameter properties.
     *
     * @param request The HTTP request associated with the
     * initialization event.  This supplied so that the initializer may
     * rely on contextual information, such information extracted from
     * headers or cookies or an associated <code>HttpSession</code>
     * object.
     * */
    void init(FormSectionEvent e) throws FormProcessException;

}
