/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo.workflow;

import java.util.ArrayList;


/**
 * This class is a standin for the proper process template domain
 * object. Process objects have a <code>key</code> which identifies them
 * uniquely, a <code>name</code> for display to the user, a
 * <code>description</code> and contain a set of tasks. Tasks are ordered
 * simply by the sequence in which they were added to the process.
 *
 * <p> <b>Warning:</b> This class is only meant for demo purposes. It's use
 * of synchronization will make sure that it becomes a bottleneck under
 * load.
 *
 * @author David Lutterkort
 * @version $Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/Process.java#8 $
 */
public class Process {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/Process.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private String m_key;
    private String m_name;
    private String m_description;
    private ArrayList m_tasks;

    public Process(String key, String name) {
        m_key = key;
        m_name = name;
        m_tasks = new ArrayList();
    }

    public final synchronized String getKey() {
        return m_key;
    }

    public final synchronized void setKey(String  v) {
        m_key = v;
    }

    // Side effect: make t depend on all previous tasks
    public synchronized void addTask(Task t) {
        addTask(t, true);
    }

    public synchronized void addTask(Task t, boolean chain) {
        if (chain && m_tasks.size()  > 0) {
            t.addDependency((Task) m_tasks.get(m_tasks.size()-1));
        }
        t.setProcess(this);
        m_tasks.add(t);
    }

    public synchronized int taskCount() {
        return m_tasks.size();
    }

    public synchronized Task getTask(int i) {
        return (Task) m_tasks.get(i);
    }

    public synchronized Task getTask(String key) {
        for (int i=0; i < taskCount(); i++) {
            Task t = getTask(i);
            if ( t.getKey().equals(key) ) {
                return t;
            }
        }
        return null;
    }

    public final synchronized String getDescription() {
        return m_description;
    }

    public final synchronized void setDescription(String s) {
        m_description = s;
    }

    public final synchronized String getName() {
        return m_name;
    }

    public final synchronized void setName(String  v) {
        m_name = v;
    }

    public synchronized static String getNextKey() {
        return String.valueOf(SampleProcesses.getInstance().size()+1);
    }

}
