/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo.workflow;


import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.ToggleLink;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.list.ListModel;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.util.GlobalizationUtil;
import java.util.NoSuchElementException;

public class Listing extends BoxPanel
    implements ChangeListener, ActionListener {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/workflow/Listing.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    private List m_list;

    private ToggleLink m_addLink;

    public Listing () {
        super(BoxPanel.VERTICAL, false);

        m_list = new List(new ProcessesListModelBuilder());
        add(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.h4workflow_templatesh4"),  false));
        add(m_list);
        m_list.addChangeListener(this);

        m_addLink = new ToggleLink(new Label(GlobalizationUtil.globalize("bebop.demo.workflow.add_template")));
        add(m_addLink);
        Label l = new Label(GlobalizationUtil.globalize("bebop.demo.workflow.add_template"));
        l.setFontWeight(Label.BOLD);
        m_addLink.setSelectedComponent(l);
        m_addLink.addActionListener(this);

    }

    public final List getList() {
        return m_list;
    }

    public final ToggleLink getAddLink() {
        return m_addLink;
    }

    // List selection has changed
    public void stateChanged(ChangeEvent e) {
        PageState s = e.getPageState();
        if ( m_list.isSelected(s) ) {
            m_addLink.setSelected(s, false);
        }
    }

    // Toggle link has been clicked
    public void actionPerformed(ActionEvent e) {
        PageState s = e.getPageState();
        if ( m_addLink.isSelected(s) ) {
            m_list.clearSelection(s);
        }
    }

    private class ProcessesListModelBuilder implements ListModelBuilder {
        private boolean m_locked;

        public ListModel makeModel(List l, PageState s) {
            return new ListModel() {
                    private int i = -1;
                    private final SampleProcesses p = SampleProcesses.getInstance();
                    private final int n = p.size();

                    public boolean next() throws NoSuchElementException {
                        i += 1;
                        return ( i < n );
                    }

                    public Object getElement() {
                        return p.get(i).getName();
                    }

                    public String getKey() {
                        return p.get(i).getKey();
                    }

                };
        }

        public void lock() {
            m_locked = true;
        }

        public final boolean isLocked() {
            return m_locked;
        }

    }
}
