/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop.demo;

import com.arsdigita.bebop.BebopMapDispatcher;
import com.arsdigita.db.ConnectionManager;
import com.arsdigita.dispatcher.Dispatcher;
import com.arsdigita.dispatcher.RequestContext;
import com.arsdigita.templating.Templating;
import com.arsdigita.xml.Document;
import com.arsdigita.xml.Element;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Demonstration dispatcher class.  Shows how you would build pages to
 * display dynamic data from the database, building
 * a DOM document and styling it with XSLT.
 *
 * <p> this class doesn't use Bebop.
 */
public class OtherDispatcher extends BebopMapDispatcher {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/demo/OtherDispatcher.java#13 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public OtherDispatcher() {
        super();
        setNotFoundDispatcher(new Dispatcher() {
                public void dispatch(HttpServletRequest req,
                                     HttpServletResponse resp,
                                     RequestContext ctx) throws ServletException,
                                                                java.io.IOException {

                    final String BEBOP_XML_NS =
                        "http://www.arsdigita.com/bebop/1.0";

                    try {
                        // build document manually
                        Element page = new Element("bebop:page", BEBOP_XML_NS);
                        Element title = new Element("bebop:title", BEBOP_XML_NS);
                        title.setText("Other dispatcher");
                        page.addContent(title);
                        Element message = new Element("bebop:label", BEBOP_XML_NS);
                        page.addContent(message);
                        message.setText("Hello!  Oracle says the current time is "
                                        + timeFromOracle());
                        Document doc = new Document(page);

                        // now we have a DOM
                        Templating.getPresentationManager()
                            .servePage(doc, req, resp);
                    } catch (Exception e) {
                        throw new ServletException(e);
                    }
                }

                private String timeFromOracle() {
                    Connection conn = null;
                    try {
                        // This use of straight JDBC is obsolete, do not
                        // use it as a good example.
                        conn = ConnectionManager.getConnection();
                        Statement s = conn.createStatement();
                        ResultSet rs = s.executeQuery
                            ("select to_char(sysdate, 'Month dd, yyyy') from dual");
                        rs.next();
                        String retval = rs.getString(1);
                        rs.close();
                        s.close();
                        return retval;
                    } catch (Exception e) {
                        return e.toString();
                    } finally {
                        try { ConnectionManager.returnConnection(conn); } catch (Exception e2) {}
                    }
                }
            });
    }
}
