/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.bebop;

import com.arsdigita.xml.Element;
import org.apache.log4j.Logger;

/**
 * A component that gets its text entirely from a single XSL element.
 *
 * @author Sameer Ajmani 
 **/
public class ElementComponent extends SimpleComponent {

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/bebop/ElementComponent.java#8 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log =
        Logger.getLogger(ElementComponent.class.getName());

    private String m_name;
    private String m_uri;

    /**
     * Constructs an ElementComponent that uses the element with the given
     * name under the given XSL namespace URI.
     *
     * @param name the name of the element to use
     * @param uri the URI of the XSL namespace
     **/
    public ElementComponent(String name, String uri) {
        m_name = name;
        m_uri = uri;
    }

    /**
     * Constructs a new element with the name and namespace given in this
     * component's constructor, and adds the element to the parent element.
     * @param state the current page state
     * @param parent the parent element for this new element
     **/
    public void generateXML(PageState state, Element parent) {
        parent.newChildElement(m_name, m_uri);
    }
}
