/*
 * Copyright (C) 2001-2004 Red Hat Inc. All Rights Reserved.
 *
 * The contents of this file are subject to the CCM Public
 * License (the "License"); you may not use this file except in
 * compliance with the License. You may obtain a copy of the
 * License at http://www.redhat.com/licenses/ccmpl.html.
 *
 * Software distributed under the License is distributed on an
 * "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
 * or implied. See the License for the specific language
 * governing rights and limitations under the License.
 *
 */
package com.arsdigita.auditing;

import com.arsdigita.initializer.Configuration;
import com.arsdigita.initializer.InitializationException;

/**
 * Initializer for the auditing service. Currently the only available
 * configuration is AuditingSaveInfoClass, which must implement the
 * AuditingSaveInfo interface.
 *
 * <p>
 * 
 * </p>
 *
 * @author Joseph Bank 
 * @version $Revision: #9 $ $Date: 2004/04/07 $
 */

public class Initializer
    implements com.arsdigita.initializer.Initializer
{

    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/auditing/Initializer.java#9 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    // configuration

    private Configuration m_conf = new Configuration();

    // constants

    static final String AUDITING_CLASS_NAME =
        "AuditingSaveInfoClass";
    static final String AUDITING_CLASS_DESC =
        "The names of the classes implementing Auditing Save Info";

    /**
     * Default constructor.
     */

    public Initializer() throws InitializationException {
        m_conf.initParameter(AUDITING_CLASS_NAME,
                             AUDITING_CLASS_DESC,
                             String.class);
    }

    /**
     * Returns the current configuration.
     * @return the current configuration.
     */

    public final Configuration getConfiguration() {
        return m_conf;
    }

    /**
     * Sets up the class that grabs AuditingSaveInfo.
     */

    public void startup() {
        try {
            String classname =
                (String)m_conf.getParameter(AUDITING_CLASS_NAME);
            AuditingSaveInfo sinfo =
                (AuditingSaveInfo) Class.forName(classname).newInstance();
            AuditingSaveFactory.setPrototype(sinfo);
        } catch (Exception e) {
            throw new InitializationException
                ("Exception initializing auiting: " + e.getMessage());
        }
    }

    /**
     * Shuts down the auditing service.
     */

    public void shutdown() {
        // empty
    }
}
