/*
 * Decompiled with CFR 0.152.
 */
package jd.xml.xslt.parser;

import java.util.Vector;
import jd.xml.xpath.axis.AttributeAxis;
import jd.xml.xpath.axis.Axis;
import jd.xml.xpath.axis.AxisLibrary;
import jd.xml.xpath.axis.ChildAxis;
import jd.xml.xpath.axis.NodeTest;
import jd.xml.xpath.axis.NodeTypeTest;
import jd.xml.xpath.expr.Expression;
import jd.xml.xpath.expr.function.Function;
import jd.xml.xpath.parser.ExpressionParser;
import jd.xml.xpath.parser.Scanner;
import jd.xml.xpath.parser.TokenConstants;
import jd.xml.xpath.parser.XPathParseException;
import jd.xml.xslt.AttributeValue;
import jd.xml.xslt.expr.InvalidExpression;
import jd.xml.xslt.expr.InvalidFunction;
import jd.xml.xslt.expr.XsltFunction;
import jd.xml.xslt.extension.ExtensionFunctionCall;
import jd.xml.xslt.parser.ParseListener;
import jd.xml.xslt.parser.XsltParseContext;
import jd.xml.xslt.parser.XsltParseException;
import jd.xml.xslt.pattern.ComposedPathPattern;
import jd.xml.xslt.pattern.FilteredStepPattern;
import jd.xml.xslt.pattern.IdPattern;
import jd.xml.xslt.pattern.KeyPattern;
import jd.xml.xslt.pattern.NodeTypeAllTest;
import jd.xml.xslt.pattern.OrPattern;
import jd.xml.xslt.pattern.Pattern;
import jd.xml.xslt.pattern.RootPattern;
import jd.xml.xslt.pattern.StepPattern;

public class PatternParser
extends ExpressionParser
implements TokenConstants {
    private boolean parsingPattern_;
    private XsltParseContext context_;
    private ParseListener parseListener_;

    public PatternParser() {
        this(new XsltParseContext());
    }

    public PatternParser(XsltParseContext xsltParseContext) {
        super(xsltParseContext);
        this.context_ = xsltParseContext;
    }

    XsltParseContext getXsltParseContext() {
        return this.context_;
    }

    public void setParseListener(ParseListener parseListener) {
        this.parseListener_ = parseListener;
    }

    public Expression parseExpression(String string) throws XPathParseException {
        Expression expression;
        try {
            expression = super.parseExpression(string);
        }
        catch (XPathParseException xPathParseException) {
            if (!this.context_.processForwardsCompatible()) {
                throw xPathParseException;
            }
            expression = new InvalidExpression(string, xPathParseException.getMessage());
        }
        if (this.parseListener_ != null) {
            expression = this.parseListener_.expressionParsed(this.context_, expression, string);
        }
        return expression;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Pattern parsePattern(String string) throws XPathParseException {
        try {
            this.parsingPattern_ = true;
            Scanner scanner = new Scanner(string);
            scanner.nextToken();
            Pattern pattern = this.parsePattern(scanner);
            if (!scanner.matchToken(27)) {
                throw scanner.createParseException("more tokens left at end of pattern (next is " + scanner.getTokenString() + ")");
            }
            if (this.parseListener_ != null) {
                pattern = this.parseListener_.patternParsed(this.context_, pattern, string);
            }
            Pattern pattern2 = pattern;
            Object var6_5 = null;
            this.parsingPattern_ = false;
            return pattern2;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.parsingPattern_ = false;
            throw throwable;
        }
    }

    private Pattern parsePattern(Scanner scanner) throws XPathParseException {
        Pattern pattern = this.parseLocationPath(scanner);
        while (scanner.consumeToken(13)) {
            pattern = new OrPattern(pattern, this.parseLocationPath(scanner));
        }
        return pattern;
    }

    private Pattern parseLocationPath(Scanner scanner) throws XPathParseException {
        if (scanner.consumeToken(9)) {
            Pattern pattern = RootPattern.INSTANCE;
            Pattern pattern2 = this.parsePossibleStep(scanner);
            if (pattern2 != null) {
                pattern = new ComposedPathPattern(pattern, pattern2, true);
                pattern = this.parsePossibleComposedPath(scanner, pattern);
            }
            return pattern;
        }
        if (scanner.consumeToken(10)) {
            Pattern pattern = RootPattern.INSTANCE;
            Pattern pattern3 = this.parseStep(scanner);
            if (pattern3 != null) {
                pattern = new ComposedPathPattern(pattern, pattern3, false);
                pattern = this.parsePossibleComposedPath(scanner, pattern);
            }
            return pattern;
        }
        if (scanner.matchToken(22)) {
            String string = scanner.value;
            scanner.nextToken();
            Pattern pattern = this.parsePossibleIdKeyPattern(scanner, string);
            if (pattern == null) {
                pattern = this.parseAbbreviatedStep(scanner, string);
            }
            return this.parsePossibleComposedPath(scanner, pattern);
        }
        Pattern pattern = this.parseStep(scanner);
        return this.parsePossibleComposedPath(scanner, pattern);
    }

    private Pattern parsePossibleComposedPath(Scanner scanner, Pattern pattern) throws XPathParseException {
        Pattern pattern2 = pattern;
        while (scanner.matchToken(9) || scanner.matchToken(10)) {
            boolean bl = scanner.matchToken(9);
            scanner.nextToken();
            Pattern pattern3 = this.parseStep(scanner);
            pattern2 = new ComposedPathPattern(pattern2, pattern3, bl);
        }
        return pattern2;
    }

    private Pattern parsePossibleIdKeyPattern(Scanner scanner, String string) throws XPathParseException {
        Pattern pattern = null;
        if (string.equals("id")) {
            if (scanner.consumeToken(1)) {
                String string2 = scanner.value;
                scanner.consumeExpectedToken(24);
                scanner.consumeExpectedToken(2);
                pattern = new IdPattern(string2);
            }
        } else if (string.equals("key") && scanner.consumeToken(1)) {
            String string3;
            try {
                string3 = this.context_.getExpandedName(scanner.value);
            }
            catch (XsltParseException xsltParseException) {
                throw scanner.createParseException("cannot expand keyname '" + scanner.value + "'");
            }
            scanner.consumeExpectedToken(24);
            scanner.consumeExpectedToken(26);
            String string4 = scanner.value;
            scanner.consumeExpectedToken(24);
            scanner.consumeExpectedToken(2);
            pattern = new KeyPattern(string3, string4);
        }
        return pattern;
    }

    private Pattern parseStep(Scanner scanner) throws XPathParseException {
        Pattern pattern = this.parsePossibleStep(scanner);
        if (pattern == null) {
            throw scanner.createParseException("StepPattern expected");
        }
        return pattern;
    }

    private Pattern parsePossibleStep(Scanner scanner) throws XPathParseException {
        Axis axis = null;
        NodeTest nodeTest = null;
        if (scanner.consumeToken(16)) {
            axis = ChildAxis.INSTANCE;
            nodeTest = this.parseNodeNameTest(scanner, null, true);
        } else {
            axis = this.parsePatternAxisSpecifier(scanner);
            if (axis == null) {
                return null;
            }
            nodeTest = this.parseNodeTest(scanner);
        }
        Expression[] expressionArray = this.parsePredicates(scanner);
        return this.createStepPattern(axis == ChildAxis.INSTANCE, nodeTest, expressionArray);
    }

    private Pattern createStepPattern(boolean bl, NodeTest nodeTest, Expression[] expressionArray) {
        nodeTest = this.normPatternNodeTest(nodeTest);
        if (expressionArray == null || expressionArray.length == 0) {
            return new StepPattern(bl, nodeTest);
        }
        return new FilteredStepPattern(bl, nodeTest, expressionArray);
    }

    private Pattern parseAbbreviatedStep(Scanner scanner, String string) throws XPathParseException {
        NodeTest nodeTest = this.parseNodeTest(scanner, string);
        Expression[] expressionArray = this.parsePredicates(scanner);
        return this.createStepPattern(true, nodeTest, expressionArray);
    }

    private Axis parsePatternAxisSpecifier(Scanner scanner) throws XPathParseException {
        Axis axis = null;
        if (scanner.matchToken(21)) {
            String string = scanner.value;
            if (string.equals(ChildAxis.INSTANCE.getName())) {
                axis = ChildAxis.INSTANCE;
            } else if (string.equals(AttributeAxis.INSTANCE.getName())) {
                axis = AttributeAxis.INSTANCE;
            } else {
                if (AxisLibrary.INSTANCE.get(string) != null) {
                    throw scanner.createParseException("axis '" + string + "' not allowed in xsl patterns");
                }
                throw scanner.createParseException("unknown axis '" + string + "'");
            }
            scanner.nextToken();
        } else if (scanner.consumeToken(18)) {
            axis = AttributeAxis.INSTANCE;
        } else if (scanner.matchToken(22)) {
            axis = ChildAxis.INSTANCE;
        }
        return axis;
    }

    private Expression[] parsePredicates(Scanner scanner) throws XPathParseException {
        Vector<Expression> vector = null;
        while (scanner.consumeToken(3)) {
            if (vector == null) {
                vector = new Vector<Expression>(1, 2);
            }
            vector.addElement(this.parseExpression(scanner));
            scanner.consumeToken(4);
        }
        Object[] objectArray = null;
        if (vector != null) {
            objectArray = new Expression[vector.size()];
            vector.copyInto(objectArray);
        }
        return objectArray;
    }

    protected Expression createFunction(Scanner scanner, String string, Expression[] expressionArray) throws XPathParseException {
        int n;
        Function function;
        int n2 = string.indexOf(58);
        if (n2 != -1) {
            String string2 = string.substring(n2 + 1);
            String string3 = this.getNamespaceUri(scanner, string.substring(0, n2));
            return new ExtensionFunctionCall(string2, string3, expressionArray);
        }
        try {
            function = this.context_.getFunctionLibrary().createFunction(string);
        }
        catch (Exception exception) {
            throw scanner.createParseException("cannot create function '" + string + "': " + exception.getMessage());
        }
        if (function == null) {
            if (this.context_.processForwardsCompatible()) {
                return new InvalidFunction("unknown function '" + string + "'");
            }
            throw scanner.createParseException("unknown function '" + string + "'");
        }
        if (this.parsingPattern_ && string.equals("current")) {
            throw scanner.createParseException("the current() function may not be used");
        }
        int n3 = n = expressionArray == null ? 0 : expressionArray.length;
        if (!function.getFunctionType().checkArgumentCount(n)) {
            String string4 = "function " + string + " does not take " + n + " arguments";
            if (this.context_.processForwardsCompatible()) {
                return new InvalidFunction(string4);
            }
            throw scanner.createParseException(string4);
        }
        function.setArguments(expressionArray);
        if (function instanceof XsltFunction) {
            ((XsltFunction)function).initContextParameters(this.context_);
        }
        return function;
    }

    private NodeTest normPatternNodeTest(NodeTest nodeTest) {
        return nodeTest != NodeTypeTest.ALL ? nodeTest : NodeTypeAllTest.INSTANCE;
    }

    public AttributeValue parseAttributeValue(String string) throws XPathParseException {
        AttributeValue attributeValue = this.parseAttributeValueInternal(string);
        if (this.parseListener_ != null) {
            attributeValue = this.parseListener_.attributeValueParsed(this.context_, attributeValue, string);
        }
        return attributeValue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AttributeValue parseAttributeValueInternal(String string) throws XPathParseException {
        String string2 = string;
        int n = string2.length();
        if (n == 0) {
            return AttributeValue.create(null, string, null);
        }
        AttributeValue attributeValue = null;
        int n2 = 0;
        int n3 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        while (n2 < n) {
            char c = string2.charAt(n2);
            if (c == '{') {
                if (n2 < n - 1 && string2.charAt(n2 + 1) == '{') {
                    stringBuffer.append('{');
                    ++n2;
                    ++n3;
                } else {
                    if (stringBuffer.length() > 0) {
                        attributeValue = AttributeValue.create(attributeValue, stringBuffer.toString(), null);
                        stringBuffer.setLength(0);
                    }
                    string2 = string2.substring(n2 + 1);
                    Scanner scanner = new Scanner(string2);
                    scanner.stopAtUnexpectedChar();
                    scanner.nextToken();
                    if (!scanner.matchToken(27)) {
                        Expression expression = this.parseExpression(scanner);
                        if (this.parseListener_ != null) {
                            expression = this.parseListener_.expressionParsed(this.context_, expression, string2.substring(0, scanner.getPosition()));
                        }
                        attributeValue = AttributeValue.create(attributeValue, null, expression);
                    }
                    if ((string2 = scanner.getRestString()).length() == 0) throw new XPathParseException(string, n3, "missing '}' at end of expression");
                    if (string2.charAt(0) != '}') {
                        throw new XPathParseException(string, n3, "missing '}' at end of expression");
                    }
                    n = string2.length();
                    n2 = 0;
                }
            } else if (c == '}') {
                if (n2 >= n - 1) throw new XPathParseException(string, n3, "standalone } detected");
                if (string2.charAt(n2 + 1) != '}') throw new XPathParseException(string, n3, "standalone } detected");
                stringBuffer.append('}');
                ++n2;
                ++n3;
            } else {
                stringBuffer.append(c);
            }
            ++n2;
            ++n3;
        }
        if (stringBuffer.length() <= 0) return attributeValue;
        return AttributeValue.create(attributeValue, stringBuffer.toString(), null);
    }
}

