/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.pdmodel.font;

import java.io.IOException;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNumber;
import org.pdfbox.pdmodel.font.PDFont;

public abstract class PDSimpleFont
extends PDFont {
    public PDSimpleFont() {
    }

    public PDSimpleFont(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public float getFontWidth(byte[] c, int offset, int length) throws IOException {
        float fontWidth = 0.0f;
        int code = this.getCodeFromArray(c, offset, length);
        COSInteger firstChar = (COSInteger)this.font.getDictionaryObject(COSName.FIRSTCHAR);
        COSInteger lastChar = (COSInteger)this.font.getDictionaryObject(COSName.LASTCHAR);
        if (firstChar != null && lastChar != null) {
            long first = firstChar.intValue();
            long last = lastChar.intValue();
            if ((long)code >= first && (long)code <= last && this.font.getDictionaryObject(COSName.WIDTHS) != null) {
                COSArray widthArray = (COSArray)this.font.getDictionaryObject(COSName.WIDTHS);
                COSNumber fontWidthObject = (COSNumber)widthArray.get((int)((long)code - first));
                fontWidth = fontWidthObject.floatValue();
            } else {
                fontWidth = this.getFontWidthFromAFMFile(code);
            }
        } else {
            fontWidth = this.getFontWidthFromAFMFile(code);
        }
        return fontWidth;
    }
}

