/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.fdf;

import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.pdfbox.encryption.DecryptDocument;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDDocumentCatalog;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.interactive.annotation.PDWidget;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDField;

public class PrintFields {
    public void printFields(PDDocument pdfDocument) {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        List fields = acroForm.getFields();
        Iterator fieldsIter = fields.iterator();
        while (fieldsIter.hasNext()) {
            PDField field = (PDField)fieldsIter.next();
            PDWidget widget = field.getWidget();
            PDRectangle rectangle = null;
            if (widget != null) {
                rectangle = widget.getRectangle();
            }
            String outputString = field.getName() + "=" + field.toString() + " rect=" + rectangle + " type=" + field.getClass().getName();
            System.out.println(outputString);
        }
    }

    public static void main(String[] args) throws IOException {
        block11: {
            try {
                PDDocument pdf;
                block12: {
                    if (args.length != 1) {
                        PrintFields.usage();
                        break block11;
                    }
                    pdf = null;
                    FileInputStream pdfStream = null;
                    try {
                        PrintFields exporter = new PrintFields();
                        pdfStream = new FileInputStream(args[0]);
                        PDFParser pdfParser = new PDFParser(pdfStream);
                        pdfParser.parse();
                        pdf = pdfParser.getPDDocument();
                        if (pdf.isEncrypted()) {
                            try {
                                DecryptDocument decryptor = new DecryptDocument(pdf);
                                decryptor.decryptDocument("");
                            }
                            catch (InvalidPasswordException e) {
                                System.err.println("Error: The document is encrypted.");
                                PrintFields.usage();
                            }
                        }
                        exporter.printFields(pdf);
                        Object var7_8 = null;
                        if (pdfStream == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var7_9 = null;
                        if (pdfStream != null) {
                            pdfStream.close();
                        }
                        if (pdf != null) {
                            pdf.close();
                        }
                        throw throwable;
                    }
                    pdfStream.close();
                }
                if (pdf != null) {
                    pdf.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: org.pdfbox.examples.fdf.PrintFields <pdf-file>");
    }
}

