/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.cos;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSArray;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSObject;
import org.pdfbox.cos.ICOSVisitor;
import org.pdfbox.exceptions.COSVisitorException;

public class COSDocument
extends COSBase {
    private float version;
    private Map objectMap = new HashMap();
    private List objects = new ArrayList();
    private COSDictionary trailer;
    private COSDictionary encryptedDictionary;
    private RandomAccessFile scratchFile = null;
    private File tmpFile = null;

    public COSDocument() throws IOException {
        this(new File(System.getProperty("java.io.tmpdir")));
    }

    public COSDocument(File scratchDir) throws IOException {
        this.tmpFile = File.createTempFile("pdfbox", "tmp", scratchDir);
        this.scratchFile = new RandomAccessFile(this.tmpFile, "rw");
    }

    public COSDocument(RandomAccessFile file) {
        this.scratchFile = file;
    }

    public RandomAccessFile getScratchFile() {
        return this.scratchFile;
    }

    public COSObject getObjectByType(COSName type) {
        COSObject retval = null;
        Iterator iter = this.objects.iterator();
        while (iter.hasNext() && retval == null) {
            COSDictionary dic;
            COSName objectType;
            COSObject object = (COSObject)iter.next();
            COSBase realObject = object.getObject();
            if (!(realObject instanceof COSDictionary) || (objectType = (COSName)(dic = (COSDictionary)realObject).getItem(COSName.TYPE)) == null || !objectType.equals(type)) continue;
            retval = object;
        }
        return retval;
    }

    public void print() {
        Iterator iter = this.objects.iterator();
        while (iter.hasNext()) {
            COSObject object = (COSObject)iter.next();
            System.out.println(object);
        }
    }

    public void setVersion(float version) {
        this.version = version;
    }

    public float getVersion() {
        return this.version;
    }

    public boolean isEncrypted() {
        COSName encrypt = COSName.getPDFName("Encrypt");
        return this.trailer.getItem(encrypt) != null && !encrypt.equals(COSNull.NULL);
    }

    public void setOriginalEncryptionDictionary(COSDictionary dict) {
        this.encryptedDictionary = dict;
    }

    public COSDictionary getEncryptionDictionary() {
        COSDictionary enc = (COSDictionary)this.trailer.getDictionaryObject(COSName.getPDFName("Encrypt"));
        if (enc == null) {
            enc = this.encryptedDictionary;
        }
        return enc;
    }

    public COSArray getDocumentID() {
        return (COSArray)this.getTrailer().getItem(COSName.getPDFName("ID"));
    }

    public void addObject(COSObject obj) {
        if (obj.getObject() == null || this.hasObject(obj)) {
            return;
        }
        this.objects.add(obj);
        this.objectMap.put(obj.getObject(), obj);
        if (obj.getObject() != null) {
            obj.getObject().addTo(this);
        }
    }

    public COSObject getCatalog() throws IOException {
        COSObject catalog = this.getObjectByType(COSName.CATALOG);
        if (catalog == null) {
            throw new IOException("Catalog cannot be found");
        }
        return catalog;
    }

    public List getObjects() {
        return new ArrayList(this.objects);
    }

    public COSDictionary getTrailer() {
        return this.trailer;
    }

    public void setTrailer(COSDictionary newTrailer) {
        this.trailer = newTrailer;
    }

    public Object accept(ICOSVisitor visitor) throws COSVisitorException {
        return visitor.visitFromDocument(this);
    }

    public boolean hasObject(COSObject obj) {
        return this.objectMap.get(obj.getObject()) != null;
    }

    public void close() throws IOException {
        if (this.scratchFile != null) {
            this.scratchFile.close();
            this.scratchFile = null;
        }
        if (this.tmpFile != null) {
            this.tmpFile.delete();
            this.tmpFile = null;
        }
    }

    protected void finalize() {
        if (this.tmpFile != null || this.scratchFile != null) {
            Throwable t = new Throwable("Warning: You did not close the PDF Document");
            t.printStackTrace();
        }
    }
}

