/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.xsltc.compiler;

import java.util.Enumeration;
import java.util.Vector;
import org.apache.bcel.generic.InstructionConstants;
import org.apache.bcel.generic.InstructionList;
import org.apache.xalan.xsltc.compiler.Parser;
import org.apache.xalan.xsltc.compiler.QName;
import org.apache.xalan.xsltc.compiler.SymbolTable;
import org.apache.xalan.xsltc.compiler.SyntaxTreeNode;
import org.apache.xalan.xsltc.compiler.Text;
import org.apache.xalan.xsltc.compiler.TopLevelElement;
import org.apache.xalan.xsltc.compiler.UseAttributeSets;
import org.apache.xalan.xsltc.compiler.XslAttribute;
import org.apache.xalan.xsltc.compiler.util.AttributeSetMethodGenerator;
import org.apache.xalan.xsltc.compiler.util.ClassGenerator;
import org.apache.xalan.xsltc.compiler.util.ErrorMsg;
import org.apache.xalan.xsltc.compiler.util.MethodGenerator;
import org.apache.xalan.xsltc.compiler.util.Type;
import org.apache.xalan.xsltc.compiler.util.TypeCheckError;

final class AttributeSet
extends TopLevelElement {
    private static final String AttributeSetPrefix = "$as$";
    private QName _name;
    private UseAttributeSets _useSets;
    private String _method;
    private boolean _ignore = false;

    AttributeSet() {
    }

    public QName getName() {
        return this._name;
    }

    public String getMethodName() {
        return this._method;
    }

    public void ignore() {
        this._ignore = true;
    }

    public void parseContents(Parser parser2) {
        String useSets;
        this._name = parser2.getQNameIgnoreDefaultNs(this.getAttribute("name"));
        if (this._name == null || this._name.equals("")) {
            ErrorMsg msg = new ErrorMsg(34, this);
            parser2.reportError(3, msg);
        }
        if ((useSets = this.getAttribute("use-attribute-sets")).length() > 0) {
            this._useSets = new UseAttributeSets(useSets, parser2);
        }
        Vector contents = this.getContents();
        int count = contents.size();
        int i = 0;
        while (i < count) {
            SyntaxTreeNode child = (SyntaxTreeNode)contents.elementAt(i);
            if (child instanceof XslAttribute) {
                parser2.getSymbolTable().setCurrentNode(child);
                child.parseContents(parser2);
            } else if (!(child instanceof Text)) {
                ErrorMsg msg = new ErrorMsg(35, this);
                parser2.reportError(3, msg);
            }
            ++i;
        }
        parser2.getSymbolTable().setCurrentNode(this);
    }

    public Type typeCheck(SymbolTable stable) throws TypeCheckError {
        if (this._ignore) {
            return Type.Void;
        }
        AttributeSet other = stable.addAttributeSet(this);
        if (other != null) {
            this._method = other.getMethodName();
            this.merge(other);
            other.ignore();
        } else {
            this._method = AttributeSetPrefix + this.getXSLTC().nextAttributeSetSerial();
        }
        if (this._useSets != null) {
            this._useSets.typeCheck(stable);
        }
        this.typeCheckContents(stable);
        return Type.Void;
    }

    private void merge(AttributeSet other) {
        if (this._useSets == null) {
            this._useSets = other._useSets;
        } else {
            this._useSets.addAttributeSets(other.getAttribute("use-attribute-sets"));
        }
        Enumeration attributes = other.elements();
        while (attributes.hasMoreElements()) {
            SyntaxTreeNode element = (SyntaxTreeNode)attributes.nextElement();
            if (!(element instanceof XslAttribute)) continue;
            this.setFirstElement((XslAttribute)element);
        }
    }

    public void translate(ClassGenerator classGen, MethodGenerator methodGen) {
        if (this._ignore) {
            return;
        }
        methodGen = new AttributeSetMethodGenerator(this._method, classGen);
        if (this._useSets != null) {
            this._useSets.translate(classGen, methodGen);
        }
        Enumeration attributes = this.elements();
        while (attributes.hasMoreElements()) {
            SyntaxTreeNode element = (SyntaxTreeNode)attributes.nextElement();
            if (!(element instanceof XslAttribute)) continue;
            XslAttribute attribute = (XslAttribute)element;
            attribute.translate(classGen, methodGen);
        }
        InstructionList il = methodGen.getInstructionList();
        il.append(InstructionConstants.RETURN);
        methodGen.stripAttributes(true);
        methodGen.setMaxLocals();
        methodGen.setMaxStack();
        methodGen.removeNOPs();
        classGen.addMethod(methodGen.getMethod());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer("attribute-set: ");
        Enumeration attributes = this.elements();
        while (attributes.hasMoreElements()) {
            XslAttribute attribute = (XslAttribute)attributes.nextElement();
            buf.append(attribute);
        }
        return buf.toString();
    }
}

