/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.util.Stack;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceWalker
extends AxesWalker {
    transient Stack m_namespaces;

    public NamespaceWalker(LocPathIterator locPathIterator) {
        super(locPathIterator);
    }

    public Object clone() throws CloneNotSupportedException {
        NamespaceWalker namespaceWalker = (NamespaceWalker)super.clone();
        if (this.m_namespaces != null) {
            namespaceWalker.m_namespaces = (Stack)this.m_namespaces.clone();
        }
        return namespaceWalker;
    }

    public Node firstChild() {
        this.m_nextLevelAmount = 0;
        return this.nextSibling();
    }

    protected int getLevelMax() {
        return this.m_lpi.getDOMHelper().getLevel(this.m_root);
    }

    public Node nextSibling() {
        Node node = this.m_namespaces.isEmpty() ? null : (Node)this.m_namespaces.pop();
        return this.setCurrentIfNotNull(node);
    }

    public void setRoot(Node node) {
        this.m_nextLevelAmount = 1;
        this.m_namespaces = new Stack();
        Node node2 = node;
        while (node2 != null) {
            NamedNodeMap namedNodeMap = node2.getAttributes();
            if (namedNodeMap != null) {
                int n = namedNodeMap.getLength();
                int n2 = n - 1;
                while (n2 >= 0) {
                    Node node3 = namedNodeMap.item(n2);
                    if (this.m_lpi.getDOMHelper().isNamespaceNode(node3)) {
                        this.m_namespaces.push(node3);
                    }
                    --n2;
                }
            }
            node2 = node2.getParentNode();
        }
        super.setRoot(node);
    }
}

