/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl.nodes;

import com.redhat.persistence.pdl.nodes.AST;
import com.redhat.persistence.pdl.nodes.AggressiveLoadNd;
import com.redhat.persistence.pdl.nodes.AssociationNd;
import com.redhat.persistence.pdl.nodes.BindingNd;
import com.redhat.persistence.pdl.nodes.ColumnNd;
import com.redhat.persistence.pdl.nodes.DataOperationNd;
import com.redhat.persistence.pdl.nodes.DbTypeNd;
import com.redhat.persistence.pdl.nodes.EventNd;
import com.redhat.persistence.pdl.nodes.FileNd;
import com.redhat.persistence.pdl.nodes.IdentifierNd;
import com.redhat.persistence.pdl.nodes.ImportNd;
import com.redhat.persistence.pdl.nodes.JavaClassNd;
import com.redhat.persistence.pdl.nodes.JoinNd;
import com.redhat.persistence.pdl.nodes.JoinPathNd;
import com.redhat.persistence.pdl.nodes.MappingNd;
import com.redhat.persistence.pdl.nodes.ModelNd;
import com.redhat.persistence.pdl.nodes.ObjectKeyNd;
import com.redhat.persistence.pdl.nodes.ObjectTypeNd;
import com.redhat.persistence.pdl.nodes.PathNd;
import com.redhat.persistence.pdl.nodes.PropertyNd;
import com.redhat.persistence.pdl.nodes.QualiasNd;
import com.redhat.persistence.pdl.nodes.ReferenceKeyNd;
import com.redhat.persistence.pdl.nodes.SQLBlockNd;
import com.redhat.persistence.pdl.nodes.StatementNd;
import com.redhat.persistence.pdl.nodes.SuperNd;
import com.redhat.persistence.pdl.nodes.TypeNd;
import com.redhat.persistence.pdl.nodes.UniqueKeyNd;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public abstract class Node {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/nodes/Node.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final HashMap TYPES = new HashMap();
    public static final Filter ALL = new Filter(){

        public boolean accept(Node child) {
            return true;
        }
    };
    private int m_line = -1;
    private int m_column = -1;
    private Node m_parent = null;
    private Field m_field = null;
    private ArrayList m_children = new ArrayList();
    private HashMap m_fields = new HashMap();

    public void dispatch(Switch sw) {
        sw.onNode(this);
    }

    public void traverse(Switch sw) {
        this.traverse(sw, ALL);
    }

    public void traverse(Switch sw, Filter f) {
        this.dispatch(sw);
        Iterator it = this.m_children.iterator();
        while (it.hasNext()) {
            Child child = (Child)it.next();
            if (!f.accept(child.getNode())) continue;
            child.getNode().traverse(sw, f);
        }
    }

    public void traverse(Traversal t) {
        this.traverse(t, t);
    }

    private void check(Field field) {
        if (field == null) {
            throw new IllegalArgumentException("Field is null.");
        }
    }

    public Object get(Field field) {
        this.check(field);
        ArrayList children = (ArrayList)this.m_fields.get(field);
        if (field.getUpper() == 1) {
            if (children == null) {
                return null;
            }
            return children.get(0);
        }
        if (children == null && (field.getUpper() > 1 || field.getUpper() < field.getLower())) {
            return Collections.EMPTY_LIST;
        }
        if (children == null) {
            throw new IllegalStateException("returning null from collection field");
        }
        return children;
    }

    public int getIndex() {
        return ((List)this.getParent().get(this.getField())).indexOf(this);
    }

    private void check(Node child) {
        if (child == null) {
            throw new IllegalArgumentException("Child is null.");
        }
        if (child.m_parent != null) {
            throw new IllegalArgumentException("Child belongs to another node: " + child);
        }
    }

    public void add(Field field, Node child) {
        this.check(field);
        this.check(child);
        child.m_parent = this;
        child.m_field = field;
        this.m_children.add(new Child(field, child));
        ArrayList<Node> children = (ArrayList<Node>)this.m_fields.get(field);
        if (children == null) {
            children = new ArrayList<Node>();
            this.m_fields.put(field, children);
        }
        children.add(child);
    }

    public Collection getFields() {
        Type t = (Type)TYPES.get(this.getClass());
        if (t == null) {
            return Collections.EMPTY_LIST;
        }
        return t.getFields();
    }

    public String validate(Field field) {
        int lower = field.getLower();
        int upper = field.getUpper();
        if (upper < lower) {
            return null;
        }
        Collection children = (Collection)this.m_fields.get(field);
        if (children == null) {
            children = Collections.EMPTY_LIST;
        }
        if (children.size() > upper) {
            return "there can be at most " + upper + " " + field.getName();
        }
        if (children.size() < lower) {
            if (upper == 1) {
                return field.getName() + " is required";
            }
            return "there must be at least " + lower + " " + field.getName();
        }
        return null;
    }

    public void setLine(int line) {
        this.m_line = line;
    }

    public int getLine() {
        return this.m_line;
    }

    public void setColumn(int column) {
        this.m_column = column;
    }

    public int getColumn() {
        return this.m_column;
    }

    public String getLocation() {
        return this.getFile().getName() + ": line " + this.getLine() + ", column " + this.getColumn();
    }

    public Field getField() {
        return this.m_field;
    }

    public Node getParent() {
        return this.m_parent;
    }

    public FileNd getFile() {
        return this.getParent().getFile();
    }

    private int getDepth() {
        if (this.m_parent == null) {
            return 0;
        }
        return this.m_parent.getDepth() + 1;
    }

    private String indent() {
        int depth = this.getDepth();
        StringBuffer result = new StringBuffer(2 * depth);
        for (int i = 0; i < depth; ++i) {
            result.append("  ");
        }
        return result.toString();
    }

    private static String getName(Class klass) {
        String full = klass.getName();
        return full.substring(full.lastIndexOf(46) + 1);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("(" + Node.getName(this.getClass()) + ": " + this.getLine() + "[" + this.getColumn() + "]");
        Iterator it = this.m_children.iterator();
        while (it.hasNext()) {
            Child child = (Child)it.next();
            result.append("\n  " + this.indent());
            result.append(child.getField());
            result.append(" = ");
            result.append(child.getNode());
        }
        result.append(")");
        return result.toString();
    }

    public static class IncludeFilter
    implements Filter {
        private HashSet m_fields = new HashSet();

        public IncludeFilter(Field[] fields) {
            for (int i = 0; i < fields.length; ++i) {
                this.m_fields.add(fields[i]);
            }
        }

        public boolean accept(Node child) {
            return this.m_fields.contains(child.getField());
        }
    }

    public static abstract class Traversal
    extends Switch
    implements Filter {
    }

    public static interface Filter {
        public boolean accept(Node var1);
    }

    public static abstract class Switch {
        public void onNode(Node node) {
        }

        public void onAST(AST ast) {
        }

        public void onFile(FileNd file) {
        }

        public void onModel(ModelNd model) {
        }

        public void onImport(ImportNd imp) {
        }

        public void onObjectType(ObjectTypeNd type) {
        }

        public void onAssociation(AssociationNd assn) {
        }

        public void onStatement(StatementNd st) {
        }

        public void onProperty(PropertyNd prop) {
        }

        public void onAggressiveLoad(AggressiveLoadNd al) {
        }

        public void onReferenceKey(ReferenceKeyNd key) {
        }

        public void onObjectKey(ObjectKeyNd key) {
        }

        public void onUniqueKey(UniqueKeyNd key) {
        }

        public void onType(TypeNd type) {
        }

        public void onJavaClass(JavaClassNd jc) {
        }

        public void onPath(PathNd path) {
        }

        public void onColumn(ColumnNd col) {
        }

        public void onDbType(DbTypeNd type) {
        }

        public void onJoinPath(JoinPathNd jp) {
        }

        public void onJoin(JoinNd join) {
        }

        public void onIdentifier(IdentifierNd id) {
        }

        public void onQualias(QualiasNd nd) {
        }

        public void onEvent(EventNd nd) {
        }

        public void onSQLBlock(SQLBlockNd nd) {
        }

        public void onSuper(SuperNd nd) {
        }

        public void onMapping(MappingNd nd) {
        }

        public void onBinding(BindingNd nd) {
        }

        public void onDataOperation(DataOperationNd nd) {
        }
    }

    private class Child {
        private Field m_field;
        private Node m_node;

        public Child(Field field, Node node) {
            this.m_field = field;
            this.m_node = node;
        }

        public Field getField() {
            return this.m_field;
        }

        public Node getNode() {
            return this.m_node;
        }
    }

    public static class Field {
        private Class m_parent;
        private String m_name;
        private Class m_type;
        private int m_lower;
        private int m_upper;

        public Field(Class parent, String name, Class type) {
            this(parent, name, type, 0);
        }

        public Field(Class parent, String name, Class type, int lower) {
            this(parent, name, type, lower, -1);
        }

        public Field(Class parent, String name, Class type, int lower, int upper) {
            this.m_parent = parent;
            this.m_name = name;
            this.m_type = type;
            this.m_lower = lower;
            this.m_upper = upper;
            Type t = (Type)TYPES.get(parent);
            if (t == null) {
                t = new Type(parent);
                TYPES.put(parent, t);
            }
            t.addField(this);
        }

        public int getLower() {
            return this.m_lower;
        }

        public int getUpper() {
            return this.m_upper;
        }

        public String getName() {
            return this.m_name;
        }

        public String toString() {
            return this.m_name;
        }
    }

    private static class Type {
        private Class m_type;
        private ArrayList m_fields = new ArrayList();

        public Type(Class type) {
            this.m_type = type;
        }

        public void addField(Field field) {
            this.m_fields.add(field);
        }

        public Collection getFields() {
            return this.m_fields;
        }
    }
}

