/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl.adapters;

import com.arsdigita.db.DbHelper;
import com.redhat.persistence.pdl.adapters.SimpleAdapter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.sql.BLOB;

public class BlobAd
extends SimpleAdapter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/adapters/BlobAd.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";

    public BlobAd() {
        super("global.Blob", 2004);
    }

    public void bind(PreparedStatement ps, int index, Object obj, int type) throws SQLException {
        ps.setBinaryStream(index, (InputStream)new ByteArrayInputStream((byte[])obj), ((byte[])obj).length);
    }

    public Object fetch(ResultSet rs, String column) throws SQLException {
        if (DbHelper.getDatabase(rs) == 2) {
            return rs.getBytes(column);
        }
        Blob blob = rs.getBlob(column);
        if (blob == null) {
            return null;
        }
        return blob.getBytes(1L, (int)blob.length());
    }

    public boolean isMutation(Object value, int jdbcType) {
        return value != null && jdbcType == 2004;
    }

    public void mutate(ResultSet rs, String column, Object value, int jdbcType) throws SQLException {
        if (DbHelper.getDatabase(rs) == 2) {
            return;
        }
        BLOB blob = (BLOB)rs.getBlob(column);
        OutputStream out = blob.getBinaryOutputStream();
        try {
            out.write((byte[])value);
            out.flush();
            out.close();
        }
        catch (IOException e) {
            throw new Error("Unable to write LOB: " + e);
        }
    }
}

