/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl;

import com.arsdigita.persistence.metadata.MetadataRoot;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.persistence.metadata.Property;
import com.arsdigita.util.Assert;
import com.arsdigita.util.AssertionError;
import com.arsdigita.versioning.Versions;
import com.redhat.persistence.metadata.Role;
import com.redhat.persistence.pdl.nodes.AssociationNd;
import com.redhat.persistence.pdl.nodes.Node;
import com.redhat.persistence.pdl.nodes.ObjectTypeNd;
import com.redhat.persistence.pdl.nodes.PropertyNd;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class VersioningMetadata {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$pdl$VersioningMetadata == null ? (class$com$redhat$persistence$pdl$VersioningMetadata = VersioningMetadata.class$("com.redhat.persistence.pdl.VersioningMetadata")) : class$com$redhat$persistence$pdl$VersioningMetadata));
    private final Set m_versionedTypes = new HashSet();
    private final Set m_unversionedProps = new HashSet();
    private static final VersioningMetadata s_singleton = new VersioningMetadata();
    static /* synthetic */ Class class$com$redhat$persistence$pdl$VersioningMetadata;

    private VersioningMetadata() {
    }

    public static VersioningMetadata getVersioningMetadata() {
        return s_singleton;
    }

    NodeSwitch nodeSwitch(Map properties) {
        return new NodeSwitch(properties);
    }

    public boolean isMarkedVersioned(String qualifiedName) {
        return this.m_versionedTypes.contains(qualifiedName);
    }

    private static Property getProperty(String containerName, String propertyName) {
        ObjectType objType = MetadataRoot.getMetadataRoot().getObjectType(containerName);
        return objType.getProperty(propertyName);
    }

    public boolean isMarkedUnversioned(String containerName, String propertyName) {
        return this.m_unversionedProps.contains(VersioningMetadata.getProperty(containerName, propertyName));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class NodeSwitch
    extends Node.Switch {
        private Map m_properties;

        public NodeSwitch(Map properties) {
            this.m_properties = properties;
        }

        public void onObjectType(ObjectTypeNd ot) {
            ObjectType objType;
            String fqn = ot.getQualifiedName();
            if (ot.isVersioned()) {
                VersioningMetadata.this.m_versionedTypes.add(fqn);
            }
            if ((objType = MetadataRoot.getMetadataRoot().getObjectType(fqn)) != null) {
                Versions.NODE_VISITOR.onObjectType(objType, ot.isVersioned());
            }
        }

        public void onProperty(PropertyNd prop) {
            if (!prop.isUnversioned() && !prop.isVersioned()) {
                return;
            }
            String containerName = this.getContainerName(prop);
            Property property = VersioningMetadata.getProperty(containerName, prop.getName().getName());
            if (property.isKeyProperty()) {
                throw new IllegalStateException("Cannot mark a key property 'unversioned': " + property);
            }
            VersioningMetadata.this.m_unversionedProps.add(property);
            if (prop.isUnversioned()) {
                Versions.NODE_VISITOR.onUnversionedProperty(property);
            } else if (prop.isVersioned()) {
                if (property.getType().isSimple()) {
                    throw new IllegalStateException("Simple properties are versioned by default. They cannot be marked 'versioned'. " + property);
                }
                Versions.NODE_VISITOR.onVersionedProperty(property);
            } else {
                throw new AssertionError("es impossible");
            }
        }

        public void onFinish() {
            Versions.NODE_VISITOR.onFinish();
        }

        private String getContainerName(PropertyNd prop) {
            Node parent = prop.getParent();
            if (parent instanceof ObjectTypeNd) {
                return ((ObjectTypeNd)parent).getQualifiedName();
            }
            Assert.truth(parent instanceof AssociationNd, "parent instanceof AssociationNd");
            AssociationNd assoc = (AssociationNd)parent;
            PropertyNd other = null;
            if (prop.equals(assoc.getRoleOne())) {
                other = assoc.getRoleTwo();
            } else if (prop.equals(assoc.getRoleTwo())) {
                other = assoc.getRoleOne();
            } else {
                throw new AssertionError("can't get here");
            }
            Role role = (Role)this.m_properties.get(other);
            if (role == null) {
                throw new IllegalStateException("Failed to look up property node=" + other);
            }
            return role.getType().getQualifiedName();
        }
    }

    public static interface NodeVisitor {
        public void onObjectType(ObjectType var1, boolean var2);

        public void onVersionedProperty(Property var1);

        public void onUnversionedProperty(Property var1);

        public void onFinish();
    }
}

