/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl;

import com.redhat.persistence.pdl.nodes.Node;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

class ErrorReport {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/ErrorReport.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private ArrayList m_messages = new ArrayList();
    private boolean m_fatal = false;

    ErrorReport() {
    }

    public void warn(Node node, String message) {
        this.m_messages.add(node.getLocation() + " [warning]: " + message);
    }

    public void fatal(Node node, String message) {
        this.m_fatal = true;
        this.m_messages.add(node.getLocation() + " [error]: " + message);
    }

    public Collection getMessages() {
        return this.m_messages;
    }

    public void check() {
        if (this.m_messages.size() == 0) {
            return;
        }
        StringBuffer buf = new StringBuffer();
        Iterator it = this.getMessages().iterator();
        while (it.hasNext()) {
            buf.append(it.next() + "\n");
        }
        this.m_messages.clear();
        if (this.m_fatal) {
            throw new Error(buf.toString());
        }
        System.err.println(buf.toString());
    }
}

