/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.pdl;

import com.arsdigita.db.DbHelper;
import com.arsdigita.persistence.Utilities;
import com.arsdigita.util.Assert;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.Table;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DDLWriter {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/pdl/DDLWriter.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private File m_base;
    private boolean m_overwrite;
    private Set m_files;
    private boolean m_isTestPDL;

    public DDLWriter(String base, Set files) {
        this(new File(base), files, false);
    }

    public DDLWriter(String base, Set files, boolean overwrite) {
        this(new File(base), files, overwrite);
    }

    public DDLWriter(File base, Set files) {
        this(base, files, false);
    }

    public DDLWriter(File base, Set files, boolean overwrite) {
        if (!base.isDirectory()) {
            throw new IllegalArgumentException("Expecting directory. " + base.getAbsolutePath() + " is not a directory.");
        }
        this.m_base = base;
        this.m_overwrite = overwrite;
        this.m_files = files;
    }

    public void setTestPDL(boolean isTestPDL) {
        this.m_isTestPDL = isTestPDL;
    }

    public void write(Root root) throws IOException {
        this.write(root.getTables());
    }

    public void write(Collection tables) throws IOException {
        boolean deferedConstraintsExist;
        int before;
        HashSet<Table> skipped = new HashSet<Table>();
        Iterator it = tables.iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            String tableFile = "table-" + table.getName() + ".sql";
            String viewFile = "view-" + table.getName() + ".sql";
            if (!this.m_overwrite && (this.m_files.contains(tableFile) || this.m_files.contains(viewFile))) {
                skipped.add(table);
                continue;
            }
            File file = new File(this.m_base, "table-" + table.getName() + "-auto.sql");
            FileWriter writer = new FileWriter(file);
            writer.write(table.getSQL());
            writer.write(";\n");
            writer.close();
        }
        HashSet deps = new HashSet();
        ArrayList uncreated = new ArrayList();
        HashSet<Table> created = new HashSet<Table>();
        HashSet<Table> deferred = new HashSet<Table>();
        ArrayList<Table> createOrder = new ArrayList<Table>();
        uncreated.addAll(tables);
        Collections.sort(uncreated, new Comparator(){

            public int compare(Object o1, Object o2) {
                Table t1 = (Table)o1;
                Table t2 = (Table)o2;
                return t1.getName().compareTo(t2.getName());
            }
        });
        do {
            before = created.size();
            Iterator it2 = uncreated.iterator();
            while (it2.hasNext()) {
                Table table = (Table)it2.next();
                deps.clear();
                deps.addAll(table.getDependencies());
                deps.retainAll(tables);
                if (!created.containsAll(deps)) continue;
                it2.remove();
                created.add(table);
                deferred.add(table);
                createOrder.add(table);
            }
        } while (created.size() > before);
        boolean bl = deferedConstraintsExist = deferred.size() > 0;
        if (deferedConstraintsExist) {
            this.writeDeferredSQL(deferred, skipped);
        }
        this.writeTableCreateAndDropSQL(createOrder, skipped, deferred);
        if (this.m_isTestPDL) {
            this.writeSetupAndTeardown(deferedConstraintsExist);
        }
        Assert.assertEquals(tables.size(), created.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSetupAndTeardown(boolean deferedConstraintsExist) throws IOException {
        FileWriter setup = new FileWriter(new File(this.m_base, "setup.sql"));
        FileWriter teardown = new FileWriter(new File(this.m_base, "teardown.sql"));
        try {
            setup.write(this.getDBFileLoadPrefix() + "create.sql" + Utilities.LINE_BREAK);
            if (deferedConstraintsExist) {
                setup.write(this.getDBFileLoadPrefix() + "deferred.sql" + Utilities.LINE_BREAK);
                teardown.write(this.getDBFileLoadPrefix() + "drop-constraints.sql" + Utilities.LINE_BREAK);
            }
            teardown.write(this.getDBFileLoadPrefix() + "drop-tables.sql" + Utilities.LINE_BREAK);
        }
        finally {
            try {
                setup.close();
            }
            catch (IOException e) {}
            try {
                teardown.close();
            }
            catch (IOException e) {}
        }
    }

    private void writeDeferredSQL(Set deferred, Set skipped) throws IOException {
        ArrayList<String> alters = new ArrayList<String>();
        ArrayList<String> dropConstraints = new ArrayList<String>();
        Iterator it = deferred.iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (skipped.contains(table)) continue;
            Iterator iter = table.getConstraints().iterator();
            while (iter.hasNext()) {
                Constraint con = (Constraint)iter.next();
                if (!con.isDeferred()) continue;
                alters.add("alter table " + table.getName() + " add " + Utilities.LINE_BREAK + con.getSQL() + ";" + Utilities.LINE_BREAK);
                if (DbHelper.getDatabase() == 2) {
                    dropConstraints.add("alter table " + table.getName() + Utilities.LINE_BREAK + " drop constraint " + con.getName() + " RESTRICT;" + Utilities.LINE_BREAK);
                    continue;
                }
                dropConstraints.add("alter table " + table.getName() + Utilities.LINE_BREAK + " drop constraint " + con.getName() + ";" + Utilities.LINE_BREAK);
            }
        }
        Collections.sort(alters);
        Collections.sort(dropConstraints);
        FileWriter writer = new FileWriter(new File(this.m_base, "deferred.sql"));
        Iterator it2 = alters.iterator();
        while (it2.hasNext()) {
            writer.write((String)it2.next());
        }
        writer.close();
        FileWriter dropFileWriter = new FileWriter(new File(this.m_base, "drop-constraints.sql"));
        Iterator it3 = dropConstraints.iterator();
        while (it3.hasNext()) {
            dropFileWriter.write((String)it3.next());
        }
        dropFileWriter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTableCreateAndDropSQL(List createOrder, Set skipped, Set deferred) throws IOException {
        FileWriter dropFileWriter = new FileWriter(new File(this.m_base, "drop-tables.sql"));
        FileWriter writer = new FileWriter(new File(this.m_base, "create.sql"));
        try {
            String loaderPrefix = this.getDBFileLoadPrefix() + this.getDDLPath();
            Iterator it = createOrder.iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                if (skipped.contains(table)) continue;
                writer.write(loaderPrefix + "table-" + table.getName() + "-auto.sql" + Utilities.LINE_BREAK);
                dropFileWriter.write("drop table " + table.getName() + ";" + Utilities.LINE_BREAK);
            }
            if (deferred.size() > 0) {
                // empty if block
            }
        }
        finally {
            writer.close();
            dropFileWriter.close();
        }
    }

    private String getDBFileLoadPrefix() {
        if (DbHelper.getDatabase() == 2) {
            return "\\i ";
        }
        return "@ ";
    }

    private String getDDLPath() {
        if (this.m_isTestPDL) {
            return "";
        }
        String dir = DbHelper.getDatabaseDirectory();
        String path = "ddl" + File.separator + dir + File.separator;
        return path;
    }
}

