/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.common.CompoundKey;
import com.redhat.persistence.common.Path;
import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.ForeignKey;
import com.redhat.persistence.metadata.ObjectType;
import com.redhat.persistence.metadata.Table;
import com.redhat.persistence.metadata.UniqueKey;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.EquiSet;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.QValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.list.SetUniqueList;
import org.apache.log4j.Logger;

class QFrame {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/QFrame.java#14 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$redhat$persistence$oql$QFrame == null ? (class$com$redhat$persistence$oql$QFrame = QFrame.class$("com.redhat.persistence.oql.QFrame")) : class$com$redhat$persistence$oql$QFrame));
    private Generator m_generator;
    private String m_alias;
    private EquiSet m_equisetpool;
    private List m_nonnullpool;
    private List m_valuespool;
    private Map m_columnspool;
    private List m_qvaluespool;
    private List m_children;
    private Expression m_expression;
    private ObjectType m_type;
    private QFrame m_container;
    private boolean m_outer;
    private List m_values;
    private Map m_mappings;
    private String m_table;
    private Expression m_tableExpr;
    private List m_colkeys;
    private Map m_columns;
    private List m_qvalues;
    private QFrame m_parent;
    private Expression m_condition;
    private Expression m_order;
    private boolean m_asc;
    private Expression m_limit;
    private Expression m_offset;
    private boolean m_hoisted;
    private QFrame m_duplicate;
    private EquiSet m_equiset;
    private List m_nonnull;
    private boolean m_equated;
    private List m_orders = new ArrayList();
    private List m_where = new ArrayList();
    private Set m_emitted = new HashSet();
    private Set m_used = new HashSet();
    private List m_equals = new ArrayList();
    private List m_from = new ArrayList();
    private List m_to = new ArrayList();
    private List m_econds = new ArrayList();
    private Map m_canonframes = new HashMap();
    static /* synthetic */ Class class$com$redhat$persistence$oql$QFrame;

    QFrame(Generator generator) {
        this.m_generator = generator;
        this.m_alias = "t" + this.m_generator.getFrames().size();
        this.m_equisetpool = new EquiSet(this.m_generator);
        this.m_nonnullpool = SetUniqueList.decorate(new ArrayList());
        this.m_valuespool = new ArrayList();
        this.m_columnspool = new HashMap();
        this.m_qvaluespool = new ArrayList();
        this.m_children = new ArrayList();
        this.m_colkeys = new ArrayList();
    }

    void init(Expression expression, ObjectType type, QFrame container) {
        this.m_expression = expression;
        this.m_type = type;
        this.m_container = container;
        this.m_children.clear();
        this.m_colkeys.clear();
        this.m_outer = false;
        this.m_values = null;
        this.m_mappings = null;
        this.m_table = null;
        this.m_tableExpr = null;
        this.m_columns = null;
        this.m_qvalues = null;
        this.m_parent = null;
        this.m_condition = null;
        this.m_order = null;
        this.m_asc = true;
        this.m_limit = null;
        this.m_offset = null;
        this.m_hoisted = false;
        this.m_duplicate = null;
        this.m_equiset = null;
        this.m_nonnull = null;
        this.m_equated = false;
    }

    Generator getGenerator() {
        return this.m_generator;
    }

    Expression getExpression() {
        return this.m_expression;
    }

    ObjectType getType() {
        return this.m_type;
    }

    QFrame getContainer() {
        return this.m_container;
    }

    void setOuter(boolean outer) {
        this.m_outer = outer;
    }

    boolean isOuter() {
        return this.m_outer || this.m_parent != null && this.m_parent.isOuter();
    }

    void setValues(String[] columns) {
        this.m_valuespool.clear();
        this.m_values = this.m_valuespool;
        for (int i = 0; i < columns.length; ++i) {
            this.m_values.add(this.getValue(columns[i]));
        }
    }

    void setValues(List values) {
        this.m_values = values;
    }

    List getValues() {
        return this.m_values;
    }

    QValue getValue(String column) {
        QValue v;
        if (this.m_columns == null) {
            this.m_columnspool.clear();
            this.m_qvaluespool.clear();
            this.m_columns = this.m_columnspool;
            this.m_qvalues = this.m_qvaluespool;
        }
        if ((v = (QValue)this.m_columns.get(column)) == null) {
            v = new QValue(this, column);
            this.m_columns.put(column, v);
            this.m_qvalues.add(v);
            this.m_colkeys.add(column);
        }
        return v;
    }

    QValue getValue(Code sql) {
        return new QValue(this, sql);
    }

    List getColumns() {
        return this.m_colkeys;
    }

    boolean hasValue(String column) {
        if (this.m_columns == null) {
            return false;
        }
        return this.m_columns.containsKey(column);
    }

    boolean hasMappings() {
        return this.m_mappings != null;
    }

    boolean hasMapping(Path p) {
        return this.hasMappings() && this.m_mappings.containsKey(p);
    }

    String getMapping(Path p) {
        return (String)this.m_mappings.get(p);
    }

    void addMapping(Path p, String c) {
        if (this.m_mappings == null) {
            this.m_mappings = new HashMap();
        }
        this.m_mappings.put(p, c);
    }

    void addMappings(Map mappings) {
        if (mappings == null) {
            return;
        }
        Iterator it = mappings.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            this.addMapping((Path)me.getKey(), (String)me.getValue());
        }
    }

    void setMappings(Map mappings) {
        this.m_mappings = mappings;
    }

    Map getMappings() {
        return this.m_mappings;
    }

    void setTable(String table) {
        this.m_table = table;
    }

    String getTable() {
        return this.m_table;
    }

    void setTable(Expression expr) {
        this.m_tableExpr = expr;
    }

    void addChild(QFrame child) {
        this.m_children.add(child);
        child.m_parent = this;
    }

    void addChild(int index, QFrame child) {
        this.m_children.add(index, child);
        child.m_parent = this;
    }

    QFrame getChild(int index) {
        return (QFrame)this.m_children.get(index);
    }

    List getChildren() {
        return this.m_children;
    }

    QFrame getParent() {
        return this.m_parent;
    }

    QFrame getRoot() {
        if (this.m_parent == null) {
            return this;
        }
        return this.m_parent.getRoot();
    }

    void setCondition(Expression condition) {
        this.m_condition = condition;
    }

    Expression getCondition() {
        return this.m_condition;
    }

    void setOrder(Expression order, boolean asc) {
        this.m_order = order;
        this.m_asc = asc;
    }

    void setLimit(Expression limit) {
        this.m_limit = limit;
    }

    Expression getLimit() {
        return this.m_limit;
    }

    void setOffset(Expression offset) {
        this.m_offset = offset;
    }

    Expression getOffset() {
        return this.m_offset;
    }

    String alias() {
        if (this.m_duplicate != null) {
            return this.m_duplicate.alias();
        }
        return this.m_alias;
    }

    EquiSet getEquiSet() {
        return this.m_equiset;
    }

    Code emit() {
        return this.emit(true, true);
    }

    Code emit(boolean select, boolean range) {
        int i;
        this.m_where.clear();
        Code join = null;
        if (!this.m_hoisted && (join = this.render(this.m_where)) != null && join.isEmpty()) {
            join = null;
        }
        Code result = new Code();
        if (select) {
            if (join != null) {
                result = result.add("(select ");
            } else if (this.m_values.size() > 1) {
                result = result.add("(");
            }
            for (i = 0; i < this.m_values.size(); ++i) {
                QValue v = (QValue)this.m_values.get(i);
                result = result.add(v.emit());
                if (i >= this.m_values.size() - 1) continue;
                result = result.add(", ");
            }
            if (this.m_values.isEmpty()) {
                result = result.add("1");
            }
        }
        if (select && join != null) {
            result = result.add("\nfrom ");
        }
        if (join != null) {
            result = result.add(join);
        }
        for (i = 0; i < this.m_where.size(); ++i) {
            result = i == 0 ? result.add("\nwhere ") : result.add(" and ");
            result = result.add((Code)this.m_where.get(i));
        }
        this.m_orders.clear();
        this.addOrders(this.m_orders);
        if (!this.m_orders.isEmpty()) {
            result = result.add("\norder by ");
        }
        for (i = 0; i < this.m_orders.size(); ++i) {
            Code key = (Code)this.m_orders.get(i);
            result = result.add(key);
            if (i >= this.m_orders.size() - 1) continue;
            result = result.add(", ");
        }
        if (range) {
            if (this.m_offset != null) {
                result = result.add("\noffset ");
                result = result.add(this.m_offset.emit(this.m_generator));
            }
            if (this.m_limit != null) {
                result = result.add("\nlimit ");
                result = result.add(this.m_limit.emit(this.m_generator));
            }
        }
        if (select && (join != null || this.m_values.size() > 1)) {
            result = result.add(")");
        }
        return result;
    }

    private void addOrders(List result) {
        if (this.m_order != null) {
            Code order = this.m_order.emit(this.m_generator);
            if (!this.m_asc) {
                order = order.add(" desc");
            }
            result.add(order);
        }
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            child.addOrders(result);
        }
    }

    String trace(LinkedList joins) {
        StringBuffer buf = new StringBuffer();
        Iterator it = joins.iterator();
        while (it.hasNext()) {
            buf.append("\n  ");
            buf.append(it.next());
        }
        return buf.toString();
    }

    private Code render(List where) {
        LinkedList joins = new LinkedList();
        this.m_emitted.clear();
        this.render(joins, where, this, this, this.m_emitted);
        Code code = null;
        Iterator it = joins.iterator();
        while (it.hasNext()) {
            JFrame frame = (JFrame)it.next();
            if (code == null) {
                code = frame.join;
                continue;
            }
            code = code.add("\ncross join ").add(frame.join);
        }
        return code;
    }

    private void render(LinkedList joins, List where, QFrame oroot, QFrame root, Set emitted) {
        Code c;
        if (this.m_outer && !joins.isEmpty()) {
            oroot = this;
        }
        Code table = null;
        if (this.m_table != null && this.m_duplicate == null) {
            table = new Code(this.m_table).add(" ").add(this.alias());
        } else if (this.m_tableExpr != null && this.m_duplicate == null) {
            table = this.m_tableExpr.emit(this.m_generator).add(" ").add(this.alias());
        }
        if (table != null) {
            joins.addFirst(JFrame.leaf(table, this, oroot));
        }
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            child.render(joins, where, oroot, root, emitted);
        }
        if (this.m_condition != null && !(c = this.m_condition.emit(this.m_generator)).isTrue() && !emitted.contains(c)) {
            this.m_used.clear();
            this.frames(this.m_condition, this.m_used);
            boolean join = false;
            Iterator it = joins.iterator();
            while (it.hasNext()) {
                JFrame frame = (JFrame)it.next();
                boolean modified = this.m_used.removeAll(frame.defined);
                if (this.m_used.isEmpty()) {
                    if (oroot.equals(root)) {
                        where.add(c);
                        continue;
                    }
                    if (frame.froot != null && oroot.equals(frame.froot)) {
                        frame.join = frame.join.add(" and ").add(c);
                        continue;
                    }
                    throw new IllegalStateException("unable to place condition: " + this.m_condition + " " + c + this.trace(joins));
                }
                if (!modified) continue;
                join = true;
                break;
            }
            if (join) {
                JFrame right = (JFrame)joins.removeFirst();
                if (joins.isEmpty()) {
                    throw new IllegalStateException("unresolved variable in condition: " + this.m_condition + " " + c + this.trace(joins));
                }
                LinkedList<JFrame> skipped = null;
                JFrame left = (JFrame)joins.removeFirst();
                while (true) {
                    this.m_used.clear();
                    this.frames(this.m_condition, this.m_used);
                    this.m_used.removeAll(right.defined);
                    boolean cross = this.m_used.removeAll(left.defined);
                    if (this.m_used.isEmpty()) break;
                    if (joins.isEmpty()) {
                        throw new IllegalStateException("unresolved variable in condition: " + this.m_condition + " " + c + this.trace(joins));
                    }
                    if (cross) {
                        JFrame lefter = (JFrame)joins.removeFirst();
                        left = JFrame.cross(lefter, left);
                        continue;
                    }
                    if (skipped == null) {
                        skipped = new LinkedList<JFrame>();
                    }
                    skipped.addLast(left);
                    left = (JFrame)joins.removeFirst();
                }
                joins.addFirst(JFrame.join(left, right, c));
                if (skipped != null) {
                    while (!skipped.isEmpty()) {
                        joins.addFirst(skipped.removeLast());
                    }
                }
            }
            emitted.add(c);
        }
    }

    void frames(Expression e, Set result) {
        this.frames(this.m_generator.getUses(e), result);
    }

    void frames(List values, Set result) {
        for (int i = 0; i < values.size(); ++i) {
            QValue value = (QValue)values.get(i);
            QFrame frame = value.getFrame().getDuplicate();
            if (!frame.getRoot().equals(this.getRoot())) continue;
            result.add(frame);
        }
    }

    void addConditions(List result) {
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            child.addConditions(result);
        }
        if (this.m_condition != null) {
            result.add(this.m_condition);
        }
    }

    boolean isSubframe(QFrame f) {
        QFrame root = this.getRoot();
        for (QFrame c = f.getContainer(); c != null; c = c.getContainer()) {
            if (!c.getRoot().equals(root)) continue;
            return true;
        }
        return false;
    }

    boolean isDescendant(QFrame frame) {
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            if (child.equals(frame)) {
                return true;
            }
            if (!child.isDescendant(frame)) continue;
            return true;
        }
        return false;
    }

    boolean isSelect() {
        if (this.m_hoisted) {
            return false;
        }
        this.m_where.clear();
        return this.render(this.m_where) != null;
    }

    boolean hoist() {
        QFrame frame = this.m_generator.getConstraining(this);
        if (frame == null) {
            return false;
        }
        if (this.m_parent != null) {
            this.m_parent.m_children.remove(this);
        }
        frame.addChild(this);
        this.m_hoisted = true;
        this.setOuter(true);
        return true;
    }

    void addInnerConditions(List result) {
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            if (child.m_outer) continue;
            child.addInnerConditions(result);
        }
        if (this.m_condition != null) {
            result.add(this.m_condition);
        }
    }

    void mergeOuter() {
        if (!this.m_outer) {
            return;
        }
        this.m_equals.clear();
        if (this.addEquals(this.m_equals)) {
            QFrame target;
            this.m_from.clear();
            this.m_to.clear();
            this.m_generator.split(this, this.m_equals, this.m_from, this.m_to);
            if (this.isConnected(this.m_to, this.m_from) && (target = ((QValue)this.m_to.get(0)).getFrame()).getRoot().equals(this.getRoot())) {
                this.m_parent.m_children.remove(this);
                target.addChild(this);
                if (!this.isNullable(this.m_to)) {
                    this.m_outer = false;
                }
            }
        }
    }

    void equifill() {
        int i;
        if (this.m_equiset == null) {
            this.m_equisetpool.clear();
            this.m_equiset = this.m_equisetpool;
        }
        if (this.m_nonnull == null) {
            this.m_nonnullpool.clear();
            this.m_nonnull = this.m_nonnullpool;
        }
        EquiSet shared = this.m_generator.getSharedFrames();
        List children = this.getChildren();
        for (i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            if (child.m_outer) {
                this.m_equals.clear();
                if (child.addEquals(this.m_equals)) {
                    this.m_from.clear();
                    this.m_to.clear();
                    this.m_generator.split(child, this.m_equals, this.m_from, this.m_to);
                    if (this.isConnected(this.m_to, this.m_from)) {
                        shared.equate(this, child);
                        child.m_equiset = this.m_equiset;
                    }
                }
                child.equifill();
                continue;
            }
            shared.equate(this, child);
            child.m_equiset = this.m_equiset;
            child.m_nonnull = this.m_nonnull;
            child.equifill();
        }
        if (this.m_condition != null) {
            List nn = this.m_generator.getNonNull(this.m_condition);
            for (int i2 = 0; i2 < nn.size(); ++i2) {
                this.m_nonnull.add(nn.get(i2));
            }
        }
        if (this.m_columns != null) {
            for (i = 0; i < this.m_qvalues.size(); ++i) {
                QValue qv = (QValue)this.m_qvalues.get(i);
                if (this.isNullable(Collections.singletonList(qv))) continue;
                this.m_nonnull.add(qv);
            }
        }
    }

    boolean innerize(Set collapse, Map canon) {
        boolean modified = false;
        if (!this.m_outer && this.m_parent != null && this.m_equiset != this.m_parent.m_equiset && this.merge(this, this.m_parent)) {
            collapse.add(this.m_equiset);
            modified = true;
        }
        if (!this.m_outer && this.m_parent != null && this.m_nonnull != this.m_parent.m_nonnull) {
            this.m_parent.m_nonnull.addAll(this.m_nonnull);
            this.m_nonnull = this.m_parent.m_nonnull;
            modified = true;
        }
        if (this.m_condition != null && !this.m_equated) {
            this.m_generator.equate(this.m_equiset, this.m_condition);
            collapse.add(this.m_equiset);
            this.m_equated = true;
            modified = true;
        }
        if (this.m_columns != null) {
            modified |= this.innerizeAncestors(this.m_qvalues);
        }
        modified |= this.merge(collapse, canon);
        if (this.m_outer) {
            this.m_equals.clear();
            if (this.addEquals(this.m_equals)) {
                QValue target;
                List vals;
                this.m_from.clear();
                this.m_to.clear();
                this.m_generator.split(this, this.m_equals, this.m_from, this.m_to);
                if (this.m_to.size() == 1 && (vals = this.m_parent.m_equiset.get(target = (QValue)this.m_to.get(0))) != null) {
                    QValue key = (QValue)this.m_from.get(0);
                    String table = key.getTable();
                    String column = key.getColumn();
                    if (table != null && column != null) {
                        for (int i = 0; i < vals.size(); ++i) {
                            QValue qv = (QValue)vals.get(i);
                            if (!table.equals(qv.getTable()) || !column.equals(qv.getColumn()) || !this.m_parent.nn(qv)) continue;
                            this.m_outer = false;
                            modified = true;
                        }
                    }
                }
            }
        }
        return modified;
    }

    private QFrame max(QFrame a, QFrame b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a.m_equiset.size() > b.m_equiset.size()) {
            return a;
        }
        return b;
    }

    private QFrame max(List frames) {
        QFrame result = null;
        for (int i = 0; i < frames.size(); ++i) {
            QFrame frame = (QFrame)frames.get(i);
            result = this.max(result, frame);
        }
        return result;
    }

    private boolean merge(QFrame a, QFrame b) {
        if (a.m_equiset == b.m_equiset) {
            return false;
        }
        EquiSet shared = this.m_generator.getSharedFrames();
        shared.equate(a, b);
        List from = shared.get(a);
        QFrame to = this.max(from);
        boolean modified = false;
        for (int i = 0; i < from.size(); ++i) {
            QFrame qf = (QFrame)from.get(i);
            if (qf.m_equiset == to.m_equiset) continue;
            to.m_equiset.addAll(qf.m_equiset);
            qf.m_equiset = to.m_equiset;
            modified = true;
        }
        return modified;
    }

    private boolean merge(Set collapse, Map canon) {
        this.m_equals.clear();
        if (!this.addEquals(this.m_equals)) {
            return false;
        }
        this.m_from.clear();
        this.m_to.clear();
        this.m_generator.split(this, this.m_equals, this.m_from, this.m_to);
        Object key = this.key(this.m_to);
        if (key == null) {
            return false;
        }
        for (int i = 0; i < this.m_from.size(); ++i) {
            QValue qv = (QValue)this.m_from.get(i);
            String t = qv.getTable();
            if (t == null) {
                return false;
            }
            String c = qv.getColumn();
            if (c == null) {
                return false;
            }
            key = new CompoundKey(new CompoundKey(key, t), c);
        }
        QFrame qf = (QFrame)canon.get(key);
        if (qf == null) {
            canon.put(key, this);
            return false;
        }
        if (this.merge(this, qf)) {
            collapse.add(this.m_equiset);
            return true;
        }
        return false;
    }

    private Object key(List qvalues) {
        if (qvalues.isEmpty()) {
            return null;
        }
        QFrame target = ((QValue)qvalues.get(0)).getFrame();
        if (!target.getRoot().equals(this.getRoot())) {
            return null;
        }
        EquiSet eq = target.m_equiset;
        Object key = eq;
        for (int i = 0; i < qvalues.size(); ++i) {
            QValue qv = (QValue)qvalues.get(i);
            Integer p = eq.partition(qv);
            key = p == null ? new CompoundKey(key, qv) : new CompoundKey(key, p);
        }
        return key;
    }

    private boolean addEquals(List equals) {
        this.m_econds.clear();
        this.addInnerConditions(this.m_econds);
        for (int i = 0; i < this.m_econds.size(); ++i) {
            Expression c = (Expression)this.m_econds.get(i);
            if (!this.m_generator.isSufficient(c)) {
                return false;
            }
            equals.addAll(this.m_generator.getEqualities(c));
        }
        return true;
    }

    private boolean nn(QValue qv) {
        List p = this.m_equiset.get(qv);
        for (int i = 0; i < this.m_nonnull.size(); ++i) {
            QValue nn = (QValue)this.m_nonnull.get(i);
            if (!nn.equals(qv) && (p == null || p != this.m_equiset.get(nn))) continue;
            return true;
        }
        if (this.m_parent == null) {
            return false;
        }
        return this.m_parent.nn(qv);
    }

    private boolean isNullable(List qvalues) {
        Column[] cols = this.columns(qvalues);
        if (cols == null) {
            return true;
        }
        return this.isNullable(cols);
    }

    private boolean isNullable(Column[] cols) {
        for (int i = 0; i < cols.length; ++i) {
            if (!cols[i].isNullable()) continue;
            return true;
        }
        return false;
    }

    private boolean isConnected(List from, List to) {
        Column[] fcols = this.columns(from);
        if (fcols == null) {
            return false;
        }
        Column[] tcols = this.columns(to);
        if (tcols == null) {
            return false;
        }
        return this.isConnected(fcols, tcols);
    }

    private Column[] columns(List qvalues) {
        if (qvalues.isEmpty()) {
            return null;
        }
        Column[] result = new Column[qvalues.size()];
        for (int i = 0; i < result.length; ++i) {
            QValue v = (QValue)qvalues.get(i);
            Table t = this.m_generator.getRoot().getTable(v.getTable());
            if (t == null) {
                return null;
            }
            Column c = t.getColumn(v.getColumn());
            if (c == null) {
                return null;
            }
            result[i] = c;
        }
        return result;
    }

    private boolean isConnected(Column[] from, Column[] to) {
        if (Arrays.equals(from, to)) {
            return true;
        }
        ForeignKey fk = from[0].getTable().getForeignKey(from);
        if (fk == null) {
            return false;
        }
        UniqueKey uk = to[0].getTable().getUniqueKey(to);
        if (uk == null) {
            return false;
        }
        return this.isConnected(fk, uk);
    }

    private boolean isConnected(ForeignKey from, UniqueKey to) {
        UniqueKey uk = from.getUniqueKey();
        if (uk.equals(to)) {
            return true;
        }
        ForeignKey fk = uk.getTable().getForeignKey(uk.getColumns());
        if (fk == null) {
            return false;
        }
        return this.isConnected(fk, to);
    }

    boolean innerizeAncestors(List values) {
        boolean modified = false;
        if (this.m_outer) {
            for (int i = 0; i < values.size(); ++i) {
                QValue v = (QValue)values.get(i);
                if (!this.m_parent.nn(v)) continue;
                this.m_outer = false;
                modified = true;
            }
        }
        if (this.m_parent != null) {
            modified |= this.m_parent.innerizeAncestors(values);
        }
        return modified;
    }

    boolean contains(QValue value) {
        return this.contains(value.getFrame());
    }

    boolean contains(QFrame frame) {
        if (frame == null) {
            return false;
        }
        if (frame.equals(this)) {
            return true;
        }
        return this.contains(frame.getParent());
    }

    boolean isConstrained(Set columns) {
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            if (child.isConstrained(columns)) continue;
            return false;
        }
        if (this.m_table != null && !this.m_generator.isConstrained(this.m_table, columns)) {
            return false;
        }
        return this.m_tableExpr == null;
    }

    void shrink() {
        if (this.m_parent == null) {
            this.m_canonframes.clear();
            this.shrink(this.m_canonframes);
        }
    }

    private void shrink(Map canon) {
        if (this.m_table != null) {
            List framesets = this.m_equiset.getFrameSets();
            QFrame[] frames = (QFrame[])canon.get(this.m_equiset);
            if (frames == null) {
                frames = new QFrame[framesets.size()];
                canon.put(this.m_equiset, frames);
            }
            Object dup = null;
            for (int i = 0; i < framesets.size(); ++i) {
                List partition = (List)framesets.get(i);
                if (!partition.contains(this) || (dup = frames[i]) != null) continue;
                frames[i] = dup = this;
            }
            if (dup != null && !dup.equals(this)) {
                this.setDuplicate((QFrame)dup);
            }
        }
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            child.shrink(canon);
        }
    }

    private void setDuplicate(QFrame dup) {
        this.m_duplicate = dup;
    }

    QFrame getDuplicate() {
        if (this.m_duplicate == null) {
            return this;
        }
        return this.m_duplicate.getDuplicate();
    }

    public String toString() {
        return this.toString(0);
    }

    private static void indent(StringBuffer buf, int depth) {
        for (int i = 0; i < depth; ++i) {
            buf.append("  ");
        }
    }

    private String toString(int depth) {
        StringBuffer result = new StringBuffer();
        QFrame.indent(result, depth);
        result.append("frame ");
        result.append(this.isOuter() ? "O" : "I");
        result.append(this.m_outer ? "o" : "i");
        result.append(" ");
        result.append(this.m_expression.summary());
        result.append(" ");
        result.append(this.m_type);
        if (this.m_table != null) {
            result.append(" ");
            result.append(this.m_table);
            result.append(" ");
            result.append(this.alias());
        }
        if (this.m_values != null) {
            result.append(" ");
            result.append(this.m_values);
        }
        if (this.m_condition != null) {
            result.append(" cond ");
            result.append(this.m_condition);
        }
        if (this.m_nonnull != null && (this.m_parent == null || this.m_nonnull != this.m_parent.m_nonnull)) {
            if (!this.m_nonnull.isEmpty()) {
                result.append("\n");
                QFrame.indent(result, depth);
            }
            result.append(" nn ");
            result.append(this.m_nonnull);
        }
        if (this.m_equiset != null && (this.m_parent == null || this.m_equiset != this.m_parent.m_equiset)) {
            if (!this.m_equiset.isEmpty()) {
                result.append("\n");
                QFrame.indent(result, depth);
            }
            result.append(" eq ");
            result.append(this.m_equiset);
        }
        if (this.getChildren().isEmpty()) {
            return result.toString();
        }
        result.append(" {");
        List children = this.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            QFrame child = (QFrame)children.get(i);
            result.append("\n");
            result.append(child.toString(depth + 1));
        }
        result.append("\n");
        QFrame.indent(result, depth);
        result.append("}");
        return result.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class JFrame {
        Code join = null;
        Set defined = null;
        QFrame froot = null;
        QFrame oroot = null;

        static JFrame leaf(Code table, QFrame frame, QFrame oroot) {
            return new JFrame(table, frame, oroot);
        }

        static JFrame cross(JFrame left, JFrame right) {
            if (!left.oroot.equals(right.oroot)) {
                throw new IllegalStateException("can't cross joins from different oroots");
            }
            Code join = left.join.add(" cross join ").add(right.join);
            JFrame result = new JFrame(join, left, right);
            result.oroot = left.oroot;
            return result;
        }

        static JFrame join(JFrame left, JFrame right, Code on) {
            Code join = left.join;
            join = left.oroot.equals(right.oroot) ? join.add("\njoin ") : join.add("\nleft join ");
            join = join.add(right.join).add(" on ").add(on);
            JFrame result = new JFrame(join, left, right);
            result.froot = right.oroot;
            result.oroot = left.oroot;
            return result;
        }

        private JFrame(Code table, QFrame frame, QFrame oroot) {
            this.join = table;
            this.defined = Collections.singleton(frame);
            this.oroot = oroot;
        }

        private JFrame(Code join, JFrame left, JFrame right) {
            this.join = join;
            this.defined = new HashSet();
            this.defined.addAll(left.defined);
            this.defined.addAll(right.defined);
        }

        public String toString() {
            return "jframe: " + this.join;
        }
    }
}

