/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.oql;

import com.redhat.persistence.PropertyMap;
import com.redhat.persistence.common.CompoundKey;
import com.redhat.persistence.metadata.Adapter;
import com.redhat.persistence.metadata.Property;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.oql.Code;
import com.redhat.persistence.oql.Expression;
import com.redhat.persistence.oql.Generator;
import com.redhat.persistence.oql.QFrame;
import com.redhat.persistence.oql.QValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class Literal
extends Expression {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/oql/Literal.java#5 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Object m_value;

    public Literal(Object value) {
        this.m_value = value;
    }

    void frame(Generator gen) {
        QFrame frame = gen.frame(this, null);
        ArrayList result = new ArrayList();
        Object key = gen.level > 0 ? null : this.getBindKey(gen);
        Literal.convert(this.m_value, result, gen.getRoot(), key);
        if (result.size() == 0) {
            throw new IllegalStateException("unable to convert value: " + this.m_value);
        }
        ArrayList<QValue> values = new ArrayList<QValue>();
        for (int i = 0; i < result.size(); ++i) {
            Code c = (Code)result.get(i);
            QValue v = frame.getValue(c);
            values.add(v);
            if (c.isNull()) {
                gen.addNull(this, v);
                continue;
            }
            gen.addNonNull(this, v);
        }
        frame.setValues(values);
    }

    Code emit(Generator gen) {
        return gen.getFrame(this).emit();
    }

    void hash(Generator gen) {
        ArrayList values = new ArrayList();
        Literal.convert(this.m_value, values, gen.getRoot(), this.getBindKey(gen));
        for (int i = 0; i < values.size(); ++i) {
            Code c = (Code)values.get(i);
            gen.hash(c.getSQL());
            gen.bind(c);
        }
        gen.hash(this.getClass());
    }

    Object getBindKey(Generator gen) {
        return gen.id(this);
    }

    static void convert(Object value, List result, Root root, Object key) {
        Literal.convert(value, result, root, key, 0);
    }

    static int convert(Object value, List result, Root root, Object key, int bindcount) {
        if (value == null) {
            result.add(Code.NULL);
        } else if (value instanceof Collection) {
            Collection c = (Collection)value;
            Code sql = new Code("(");
            Iterator it = c.iterator();
            while (it.hasNext()) {
                ArrayList single = new ArrayList();
                bindcount = Literal.convert(it.next(), single, root, key, bindcount);
                if (single.size() != 1) {
                    throw new IllegalStateException("can't deal with collection of compound objects");
                }
                sql = sql.add((Code)single.get(0));
                if (it.hasNext()) {
                    sql = sql.add(",");
                    continue;
                }
                sql = sql.add(")");
            }
            result.add(sql);
        } else {
            Adapter ad = root.getAdapter(value.getClass());
            PropertyMap pmap = ad.getProperties(value);
            if (pmap.getObjectType().isCompound()) {
                bindcount = Literal.convert(pmap, result, root, key, bindcount);
            } else {
                CompoundKey k = key == null ? null : new CompoundKey(key, new Integer(bindcount));
                Code.Binding b = new Code.Binding(k, value, ad.defaultJDBCType());
                result.add(new Code("?", Collections.singletonList(b)));
                ++bindcount;
            }
        }
        return bindcount;
    }

    private static int convert(PropertyMap pmap, List result, Root root, Object key, int bindcount) {
        Collection props = Code.properties(pmap.getObjectType());
        Iterator it = props.iterator();
        while (it.hasNext()) {
            Property prop = (Property)it.next();
            bindcount = Literal.convert(pmap.get(prop), result, root, key, bindcount);
        }
        return bindcount;
    }

    public String toString() {
        if (this.m_value instanceof String) {
            return "\"" + this.m_value + "\"";
        }
        return "" + this.m_value;
    }

    String summary() {
        return "" + this;
    }
}

