/*
 * Decompiled with CFR 0.152.
 */
package com.redhat.persistence.metadata;

import com.redhat.persistence.metadata.Column;
import com.redhat.persistence.metadata.Constraint;
import com.redhat.persistence.metadata.Element;
import com.redhat.persistence.metadata.ForeignKey;
import com.redhat.persistence.metadata.Mist;
import com.redhat.persistence.metadata.Root;
import com.redhat.persistence.metadata.UniqueKey;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Table
extends Element {
    public static final String versionId = "$Id: //core-platform/dev/src/com/redhat/persistence/metadata/Table.java#6 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private String m_name;
    private Mist m_columns = new Mist(this);
    private Set m_constraints = new HashSet();
    private UniqueKey m_key = null;
    private static ThreadLocal s_cols = new ThreadLocal(){

        public Object initialValue() {
            return new HashSet();
        }
    };
    private static ThreadLocal s_key = new ThreadLocal(){

        public Object initialValue() {
            return new HashSet();
        }
    };
    static /* synthetic */ Class class$com$redhat$persistence$metadata$UniqueKey;
    static /* synthetic */ Class class$com$redhat$persistence$metadata$ForeignKey;

    public Table(String name) {
        this.m_name = name;
    }

    public String getName() {
        return this.m_name;
    }

    public Root getRoot() {
        return (Root)this.getParent();
    }

    public void setPrimaryKey(UniqueKey constraint) {
        this.m_key = constraint;
    }

    public UniqueKey getPrimaryKey() {
        return this.m_key;
    }

    Constraint getConstraint(Class type, Column[] columns) {
        Set cols = (Set)s_cols.get();
        cols.clear();
        for (int i = 0; i < columns.length; ++i) {
            cols.add(columns[i]);
        }
        Set key = (Set)s_key.get();
        key.clear();
        Iterator it = this.m_constraints.iterator();
        while (it.hasNext()) {
            Constraint con = (Constraint)it.next();
            if (!type.isInstance(con)) continue;
            Column[] keyCols = con.getColumns();
            key.clear();
            for (int i = 0; i < keyCols.length; ++i) {
                key.add(keyCols[i]);
            }
            if (!((Object)cols).equals(key)) continue;
            return con;
        }
        return null;
    }

    public UniqueKey getUniqueKey(Column[] columns) {
        return (UniqueKey)this.getConstraint(class$com$redhat$persistence$metadata$UniqueKey == null ? (class$com$redhat$persistence$metadata$UniqueKey = Table.class$("com.redhat.persistence.metadata.UniqueKey")) : class$com$redhat$persistence$metadata$UniqueKey, columns);
    }

    public UniqueKey getUniqueKey(Column column) {
        return this.getUniqueKey(new Column[]{column});
    }

    public ForeignKey getForeignKey(Column[] columns) {
        return (ForeignKey)this.getConstraint(class$com$redhat$persistence$metadata$ForeignKey == null ? (class$com$redhat$persistence$metadata$ForeignKey = Table.class$("com.redhat.persistence.metadata.ForeignKey")) : class$com$redhat$persistence$metadata$ForeignKey, columns);
    }

    public ForeignKey getForeignKey(Column column) {
        return this.getForeignKey(new Column[]{column});
    }

    public void addColumn(Column column) {
        this.m_columns.add(column);
    }

    public Column getColumn(String name) {
        return (Column)this.m_columns.get(name);
    }

    void addConstraint(Constraint constraint) {
        this.m_constraints.add(constraint);
    }

    public Set getConstraints() {
        return this.m_constraints;
    }

    public String getSQL() {
        return this.getSQL(true);
    }

    public String getSQL(boolean defer) {
        StringBuffer result = new StringBuffer();
        ArrayList<Column> columns = new ArrayList<Column>();
        columns.addAll(this.m_columns);
        for (int i = 0; i < columns.size(); ++i) {
            Column col = (Column)columns.get(i);
            if (!col.hasPrimaryKey()) continue;
            columns.remove(i);
            columns.add(0, col);
        }
        result.append("create table " + this.getName() + " (\n");
        String comment = null;
        for (int i = 0; i < columns.size(); ++i) {
            boolean hasNext;
            Column column = (Column)columns.get(i);
            result.append(column.getInlineSQL(defer));
            boolean bl = hasNext = i < columns.size() - 1;
            if (hasNext) {
                result.append(",\n");
            }
            if (!defer || !column.hasDeferredConstraints()) continue;
            comment = "        -- referential constraint for " + column.getName() + " deferred due to circular dependencies";
            if (!hasNext) continue;
            result.append(comment);
            result.append("\n");
            comment = null;
        }
        boolean compoundDeferred = false;
        Iterator it = this.m_constraints.iterator();
        while (it.hasNext()) {
            Constraint con = (Constraint)it.next();
            if (con.getColumns().length <= 1) continue;
            if (con.isDeferred()) {
                compoundDeferred = true;
                continue;
            }
            if (comment != null) {
                result.append(",\n");
                result.append(comment);
                result.append("\n");
                comment = null;
            } else {
                result.append(",\n");
            }
            result.append(con.getSQL());
        }
        if (comment != null) {
            result.append("\n");
            result.append(comment);
            comment = null;
        }
        if (compoundDeferred) {
            result.append("\n    -- compound referential constraints deferred due to circular dependencies");
        }
        result.append("\n)");
        return result.toString();
    }

    public boolean isCircular() {
        return this.getAllDependencies().contains(this);
    }

    private Set getAllDependencies() {
        int before;
        HashSet result = new HashSet();
        this.getDependencies(result, true);
        do {
            before = result.size();
            ArrayList tables = new ArrayList();
            tables.addAll(result);
            Iterator it = tables.iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                table.getDependencies(result, true);
            }
        } while (result.size() > before);
        return result;
    }

    public Set getDependencies() {
        HashSet result = new HashSet();
        this.getDependencies(result, false);
        return result;
    }

    private void getDependencies(Set result, boolean includeDeferred) {
        Iterator it = this.m_constraints.iterator();
        while (it.hasNext()) {
            ForeignKey fk;
            Table table;
            Constraint con = (Constraint)it.next();
            if (!includeDeferred && con.isDeferred() || !(con instanceof ForeignKey) || (table = (fk = (ForeignKey)con).getUniqueKey().getTable()) == this) continue;
            result.add(table);
        }
    }

    Object getElementKey() {
        return this.getName();
    }

    public String toString() {
        return this.m_name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

