/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.workflow.simple;

import com.arsdigita.domain.DataObjectNotFoundException;
import com.arsdigita.domain.DomainObjectFactory;
import com.arsdigita.kernel.Group;
import com.arsdigita.kernel.GroupCollection;
import com.arsdigita.kernel.Kernel;
import com.arsdigita.kernel.Party;
import com.arsdigita.kernel.PartyCollection;
import com.arsdigita.kernel.User;
import com.arsdigita.kernel.UserCollection;
import com.arsdigita.messaging.Message;
import com.arsdigita.notification.Notification;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.metadata.ObjectType;
import com.arsdigita.runtime.RuntimeConfigLoader;
import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.workflow.simple.Assignable;
import com.arsdigita.workflow.simple.Duration;
import com.arsdigita.workflow.simple.Task;
import com.arsdigita.workflow.simple.TaskException;
import com.arsdigita.workflow.simple.WorkflowConfig;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class UserTask
extends Task
implements Assignable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/workflow/simple/UserTask.java#23 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private static final WorkflowConfig CONFIG = new WorkflowConfig();
    public static final String BASE_DATA_OBJECT_TYPE = "com.arsdigita.workflow.simple.UserTask";
    private static final String ASSIGNED_USERS = "assignedUsers";
    private static final String ASSIGNED_GROUPS = "assignedGroups";
    private static final String LOCKING_USER_ID = "lockingUserId";
    private static final String IS_LOCKED = "isLocked";
    private static final String DUE_DATE = "dueDate";
    private static final String START_DATE = "startDate";
    private static final String DURATION_MINUTES = "durationMinutes";
    private static final String NOTIFICATION_SENDER_ID = "notificationSenderID";
    public static final int DEFAULT_DURATION = 1440;
    private User m_userLock;
    private HashSet m_assignedUsers;
    private HashSet m_assignedGroups;
    private User m_finished_user;
    private Party m_notificationSender;
    public static final String ENABLE_OP = "enable";
    public static final String DISABLE_OP = "disable";
    public static final String ROLLBACK_OP = "rollback";
    public static final String FINISH_OP = "finish";
    private static final Logger s_log;
    static /* synthetic */ Class class$com$arsdigita$workflow$simple$UserTask;

    public UserTask(String label, String description, boolean is_active, int duration_minutes) {
        this(label, description);
        this.setDuration(new Duration(0, 0, duration_minutes));
    }

    public UserTask(String label, String description) {
        this(BASE_DATA_OBJECT_TYPE);
        this.setDuration(new Duration(1440));
        this.initAttributes(label, description);
    }

    public UserTask() {
        this(BASE_DATA_OBJECT_TYPE);
        this.setDuration(new Duration(0));
    }

    protected UserTask(ObjectType type) {
        super(type);
    }

    protected UserTask(String typeName) {
        super(typeName);
        this.setDuration(new Duration(0, 0, 0));
    }

    public UserTask(DataObject userTaskObject) {
        super(userTaskObject);
    }

    public UserTask(OID oid) throws DataObjectNotFoundException {
        super(oid);
    }

    public UserTask(BigDecimal id) throws DataObjectNotFoundException {
        this(new OID(BASE_DATA_OBJECT_TYPE, (Object)id));
    }

    public OID getUserTaskOID() {
        return new OID(this.getBaseDataObjectType(), (Object)this.getID());
    }

    public Date getStartDate() {
        return (Date)this.get(START_DATE);
    }

    public Date getDueDate() {
        return (Date)this.get(DUE_DATE);
    }

    public void setStartDate(Date startDate) {
        this.set(START_DATE, startDate);
    }

    public void setDuration(Duration duration) {
        this.setStartDate(duration.getStartDate());
        this.setDueDate(duration.getDueDate());
        this.set(DURATION_MINUTES, new BigDecimal((double)duration.getDuration()));
    }

    public Duration getDuration() {
        BigDecimal minutes = (BigDecimal)this.get(DURATION_MINUTES);
        if (minutes == null) {
            minutes = new BigDecimal(0.0);
        }
        return new Duration(minutes.intValue());
    }

    public void setDueDate(Date dueDate) {
        this.set(DUE_DATE, dueDate);
    }

    public void finish(User user) throws TaskException {
        if (this.isLocked() && !this.getLockedUser().equals(user)) {
            throw new TaskException("Not Locking User");
        }
        this.m_finished_user = user;
        this.finish();
    }

    public void enable() {
        this.setDuration(new Duration(this.getDuration().getDuration()));
        super.enable();
    }

    public void enableEvt() {
        Party sender = this.getNotificationSender();
        if (this.sendAlerts(ENABLE_OP) && sender != null) {
            Message msg = this.generateMessage(ENABLE_OP, sender);
            this.sendMessageToAssignees(msg);
        }
        super.enableEvt();
    }

    protected void finishEvt() {
        User current = null;
        Party party = Kernel.getContext().getParty();
        try {
            current = User.retrieve(party.getOID());
        }
        catch (DataObjectNotFoundException e) {
            throw new UncheckedWrapperException(e);
        }
        this.unlock(current);
        Party sender = this.getNotificationSender();
        if (this.sendAlerts(FINISH_OP) && sender != null) {
            Message msg = this.generateMessage(FINISH_OP, sender);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Sending alert message with body " + msg.getBody() + " for finishEvt."));
            }
            this.sendMessageToAssignees(msg);
        }
        super.finishEvt();
    }

    protected void rollbackEvt() {
        Party sender = this.getNotificationSender();
        if (this.sendAlerts(ROLLBACK_OP) && sender != null) {
            Message msg = this.generateMessage(ROLLBACK_OP, sender);
            this.sendMessageToAssignees(msg);
        }
        super.rollbackEvt();
    }

    protected void disableEvt() {
        Party sender = this.getNotificationSender();
        if (this.sendAlerts(DISABLE_OP) && sender != null) {
            Message msg = this.generateMessage(DISABLE_OP, sender);
            this.sendMessageToAssignees(msg);
        }
        super.disableEvt();
    }

    protected Message generateMessage(String operation, Party sender) {
        String subject = null;
        String body = null;
        if (ENABLE_OP.equals(operation)) {
            subject = this.getLabel() + "is in ready state.";
            body = this.getLabel() + " moved to ready state from disabled on " + new Date();
        } else if (DISABLE_OP.equals(operation)) {
            subject = this.getLabel() + " moved to disable state.";
            body = this.getLabel() + " was moved to disable state from ready on " + new Date();
        } else if (ROLLBACK_OP.equals(operation)) {
            subject = this.getLabel() + " moved to disable state.";
            body = this.getLabel() + " moved to disable state from finished on " + new Date();
        } else if (FINISH_OP.equals(operation)) {
            subject = this.getLabel() + "was finished.";
            body = this.getLabel() + " completed on " + new Date() + (this.m_finished_user != null ? "by: " + this.m_finished_user.getName() : "");
        } else {
            throw new IllegalArgumentException("Invalid workflow operation: " + operation);
        }
        body = body + "\nDescription: " + this.getDescription() + "\n";
        Message msg = new Message(sender, subject, body);
        msg.save();
        return msg;
    }

    protected void sendMessageToAssignees(Message msg) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Sending message: " + msg.getBody() + " to all assignees."));
        }
        Iterator itr = this.getAssignedUsers();
        Party tempParty = null;
        Notification notification = null;
        while (itr.hasNext()) {
            tempParty = (Party)itr.next();
            notification = new Notification(tempParty, msg);
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Sending message to user " + tempParty.getDisplayName()));
            }
            notification.save();
        }
        itr = this.getAssignedGroups();
        while (itr.hasNext()) {
            tempParty = (Party)itr.next();
            if (s_log.isDebugEnabled()) {
                s_log.debug((Object)("Sending message to group " + tempParty.getDisplayName()));
            }
            notification = new Notification(tempParty, msg);
            notification.save();
        }
    }

    public void finish(User user, String comment) throws TaskException {
        this.finish();
        this.addComment(user, comment);
    }

    public void lock(User user) {
        this.m_userLock = user;
        this.set(LOCKING_USER_ID, user.getID());
        this.set(IS_LOCKED, "t");
    }

    public void unlock(User user) {
        this.m_userLock = null;
        this.set(LOCKING_USER_ID, null);
        this.set(IS_LOCKED, "f");
    }

    public boolean isLocked() {
        return this.getLockedUser() != null;
    }

    public User getLockedUser() {
        if (this.m_userLock == null) {
            BigDecimal userID = (BigDecimal)this.get(LOCKING_USER_ID);
            try {
                if (userID != null) {
                    this.m_userLock = User.retrieve(userID);
                }
            }
            catch (DataObjectNotFoundException e) {
                this.m_userLock = null;
            }
        }
        return this.m_userLock;
    }

    public void assignUser(User user) {
        Collection users = this.getInternalAssignedUsers();
        if (!users.contains(user)) {
            this.add(ASSIGNED_USERS, user);
            users.add(user);
        }
    }

    public void assignGroup(Group group) {
        this.add(ASSIGNED_GROUPS, group);
        Collection groups = this.getInternalAssignedGroups();
        groups.add(group);
    }

    public void removeUser(User user) {
        Collection users = this.getInternalAssignedUsers();
        users.remove(user);
        user.removeFromAssociation(this.getAssignedUserAssociation());
    }

    public void removeGroup(Group group) {
        Collection groups = this.getInternalAssignedGroups();
        groups.remove(group);
        group.removeFromAssociation(this.getAssignedGroupAssociation());
    }

    public void removeAllGroupAssignees() {
        Collection groups = this.getInternalAssignedGroups();
        Iterator i = groups.iterator();
        while (i.hasNext()) {
            Group g = (Group)i.next();
            g.removeFromAssociation(this.getAssignedGroupAssociation());
        }
        groups.clear();
    }

    public boolean isAssigned() {
        return this.getAssignedUserCount() > 0 || this.getAssignedGroupCount() > 0;
    }

    public boolean isAssigned(User user) {
        Collection users = this.getInternalAssignedUsers();
        Iterator userItr = users.iterator();
        User tmpUser = null;
        while (userItr.hasNext()) {
            tmpUser = (User)userItr.next();
            if (tmpUser == null) {
                return false;
            }
            if (!tmpUser.getID().equals(user.getID())) continue;
            return true;
        }
        return false;
    }

    public boolean isAssigned(Group group) {
        Collection groups = this.getInternalAssignedGroups();
        Iterator groupItr = groups.iterator();
        Group tmpGroup = null;
        while (groupItr.hasNext()) {
            tmpGroup = (Group)groupItr.next();
            if (tmpGroup == null) {
                return false;
            }
            if (!tmpGroup.getID().equals(group.getID())) continue;
            return true;
        }
        return false;
    }

    public int getAssignedUserCount() {
        return this.getInternalAssignedUsers().size();
    }

    public int getAssignedGroupCount() {
        return this.getInternalAssignedGroups().size();
    }

    public Iterator getAssignedUsers() {
        return this.getInternalAssignedUsers().iterator();
    }

    private Collection getInternalAssignedUsers() {
        if (this.m_assignedUsers == null) {
            UserCollection uc = new UserCollection(this.getAssignedUserAssociation().cursor());
            this.m_assignedUsers = new HashSet();
            while (uc.next()) {
                this.m_assignedUsers.add(uc.getDomainObject());
            }
        }
        return this.m_assignedUsers;
    }

    private Collection getInternalAssignedGroups() {
        if (this.m_assignedGroups == null) {
            this.m_assignedGroups = new HashSet();
            GroupCollection gc = new GroupCollection(this.getAssignedGroupAssociation().cursor()){};
            while (gc.next()) {
                this.m_assignedGroups.add(gc.getDomainObject());
            }
        }
        return this.m_assignedGroups;
    }

    public Iterator getAssignedGroups() {
        return this.getInternalAssignedGroups().iterator();
    }

    protected DataAssociation getAssignedUserAssociation() {
        return (DataAssociation)this.get(ASSIGNED_USERS);
    }

    public final UserCollection getAssignedUserCollection() {
        return new UserCollection(this.getAssignedUserAssociation().cursor());
    }

    protected DataAssociation getAssignedGroupAssociation() {
        return (DataAssociation)this.get(ASSIGNED_GROUPS);
    }

    public final GroupCollection getAssignedGroupCollection() {
        return new GroupCollection(this.getAssignedGroupAssociation().cursor());
    }

    private void clearUser() {
        Collection users = this.getInternalAssignedUsers();
        HashSet users2 = new HashSet();
        Iterator itr = users.iterator();
        while (itr.hasNext()) {
            users2.add(itr.next());
        }
        itr = users2.iterator();
        while (itr.hasNext()) {
            this.removeUser((User)itr.next());
        }
    }

    private void clearGroup() {
        Collection groups = this.getInternalAssignedGroups();
        HashSet groups2 = new HashSet();
        Iterator itr = groups.iterator();
        while (itr.hasNext()) {
            groups2.add(itr.next());
        }
        itr = groups2.iterator();
        while (itr.hasNext()) {
            this.removeGroup((Group)itr.next());
        }
    }

    public void delete() {
        if (this.getAssignedUserCount() > 0) {
            this.clearUser();
        }
        if (this.getAssignedGroupCount() > 0) {
            this.clearGroup();
        }
        super.delete();
    }

    public boolean isOverdue() {
        Date now = new Date();
        Date dueDate = this.getDueDate();
        if (dueDate == null) {
            return false;
        }
        return dueDate.getTime() < now.getTime();
    }

    public Party setNotificationSender(Party party) {
        Party previousSender = this.getInternalNotificationSender();
        this.setInternalNotificationSender(party);
        return previousSender;
    }

    public Party getNotificationSender() {
        return this.getInternalNotificationSender();
    }

    private void setInternalNotificationSender(Party party) {
        if (party == null) {
            this.set(NOTIFICATION_SENDER_ID, null);
        } else {
            this.set(NOTIFICATION_SENDER_ID, party.getID());
            this.m_notificationSender = party;
        }
    }

    private Party getInternalNotificationSender() {
        if (this.m_notificationSender == null) {
            BigDecimal senderID = (BigDecimal)this.get(NOTIFICATION_SENDER_ID);
            if (senderID == null) {
                return null;
            }
            try {
                this.m_notificationSender = (Party)DomainObjectFactory.newInstance(new OID("com.arsdigita.kernel.Party", (Object)senderID));
                Assert.assertNotNull(this.m_notificationSender, "Party m_notificationSender");
            }
            catch (DataObjectNotFoundException e) {
                throw new UncheckedWrapperException("Error restoring notification sender", e);
            }
        }
        return this.m_notificationSender;
    }

    public Object clone() {
        UserTask taskClone = new UserTask();
        this.copyAttributes(taskClone);
        return taskClone;
    }

    protected void copyAttributes(UserTask task) {
        super.copyAttributes(task);
        task.setDuration(new Duration(0, 0, this.getDuration().getDuration()));
        Collection assignedUsers = this.getInternalAssignedUsers();
        Iterator userItr = assignedUsers.iterator();
        while (userItr.hasNext()) {
            User user = (User)userItr.next();
            task.assignUser(user);
        }
        Collection assignedGroups = this.getInternalAssignedGroups();
        Iterator groupItr = assignedGroups.iterator();
        while (groupItr.hasNext()) {
            Group group = (Group)groupItr.next();
            task.assignGroup(group);
        }
        task.setNotificationSender(UserTask.getAlertsSender());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Party getAlertsSender() {
        String email = CONFIG.getAlertsSender();
        if (email == null) {
            return null;
        }
        PartyCollection parties = Party.retrieveAllParties();
        parties.addEqualsFilter("primaryEmail", email.toLowerCase());
        try {
            if (parties.next()) {
                Party party = parties.getParty();
                return party;
            }
            Party party = null;
            return party;
        }
        finally {
            parties.close();
        }
    }

    protected boolean sendAlerts(String operation) {
        return CONFIG.isAlertsEnabled();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CONFIG.load(new RuntimeConfigLoader("ccm-core/workflow.properties", false));
        s_log = Logger.getLogger((Class)(class$com$arsdigita$workflow$simple$UserTask == null ? (class$com$arsdigita$workflow$simple$UserTask = UserTask.class$(BASE_DATA_OBJECT_TYPE)) : class$com$arsdigita$workflow$simple$UserTask));
    }
}

