/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.web;

import com.arsdigita.developersupport.DeveloperSupport;
import com.arsdigita.dispatcher.RequestEvent;
import com.arsdigita.util.Assert;
import com.arsdigita.web.BaseDispatcher;
import com.arsdigita.web.BaseServlet;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Logger;

public class DispatcherServlet
extends BaseServlet {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/web/DispatcherServlet.java#17 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$web$DispatcherServlet == null ? (class$com$arsdigita$web$DispatcherServlet = DispatcherServlet.class$("com.arsdigita.web.DispatcherServlet")) : class$com$arsdigita$web$DispatcherServlet));
    public static final String FALLBACK_SERVLET_PARAMETER = "fallback-servlet";
    public static final String FALLING_BACK_ATTRIBUTE = (class$com$arsdigita$web$DispatcherServlet == null ? (class$com$arsdigita$web$DispatcherServlet = DispatcherServlet.class$("com.arsdigita.web.DispatcherServlet")) : class$com$arsdigita$web$DispatcherServlet).getName() + ".falling_back";
    private String m_fallbackName = null;
    private final BaseDispatcher m_dispatcher = new BaseDispatcher();
    static /* synthetic */ Class class$com$arsdigita$web$DispatcherServlet;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$javax$servlet$RequestDispatcher;

    public void doInit() throws ServletException {
        this.m_fallbackName = this.getServletConfig().getInitParameter(FALLBACK_SERVLET_PARAMETER);
        Assert.exists(this.m_fallbackName, class$java$lang$String == null ? (class$java$lang$String = DispatcherServlet.class$("java.lang.String")) : class$java$lang$String);
        Assert.exists(this.getServletConfig().getServletContext().getNamedDispatcher(this.m_fallbackName), class$javax$servlet$RequestDispatcher == null ? (class$javax$servlet$RequestDispatcher = DispatcherServlet.class$("javax.servlet.RequestDispatcher")) : class$javax$servlet$RequestDispatcher);
    }

    protected void doService(HttpServletRequest sreq, HttpServletResponse sresp) throws ServletException, IOException {
        DeveloperSupport.requestStart(new RequestEvent(sreq, sresp, null, true, false));
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Servicing request '" + sreq.getRequestURI() + "'"));
        }
        DeveloperSupport.startStage("BaseDispatcher.dispatch");
        boolean dispatched = this.m_dispatcher.dispatch(sreq, sresp);
        DeveloperSupport.endStage("BaseDispatcher.dispatch");
        if (dispatched) {
            s_log.debug((Object)"Successfully dispatched to an application");
        } else {
            s_log.debug((Object)"Could not dispatch this request to an application;  using the fallback servlet");
            sreq.setAttribute(FALLING_BACK_ATTRIBUTE, (Object)Boolean.TRUE);
            DeveloperSupport.startStage("BaseDispatcher.forward");
            RequestDispatcher fallbackDispatcher = this.getServletConfig().getServletContext().getNamedDispatcher(this.m_fallbackName);
            this.m_dispatcher.forward(fallbackDispatcher, sreq, sresp);
            DeveloperSupport.endStage("BaseDispatcher.forward");
        }
    }

    protected void doDestroy() {
        this.m_fallbackName = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

