/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.versioning;

import com.arsdigita.db.DbHelper;
import com.arsdigita.persistence.DataAssociation;
import com.arsdigita.persistence.DataObject;
import com.arsdigita.persistence.OID;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.util.Assert;
import com.arsdigita.versioning.Adapter;
import com.arsdigita.versioning.Constants;
import com.arsdigita.versioning.EventType;
import com.arsdigita.versioning.ObjectTypeMetadata;
import com.arsdigita.versioning.OpType;
import com.arsdigita.versioning.Types;
import com.arsdigita.versioning.functions;
import com.redhat.persistence.AddEvent;
import com.redhat.persistence.CreateEvent;
import com.redhat.persistence.DeleteEvent;
import com.redhat.persistence.PropertyEvent;
import com.redhat.persistence.RemoveEvent;
import com.redhat.persistence.SetEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

final class DataObjectChange
implements Constants {
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$versioning$DataObjectChange == null ? (class$com$arsdigita$versioning$DataObjectChange = DataObjectChange.class$("com.arsdigita.versioning.DataObjectChange")) : class$com$arsdigita$versioning$DataObjectChange));
    private static final int MAX_GENERIC = 4000;
    private DataObject m_dobj;
    private boolean m_isRecoverable;
    private List m_pending;
    static /* synthetic */ Class class$com$arsdigita$versioning$DataObjectChange;
    static /* synthetic */ Class class$com$arsdigita$persistence$OID;

    public DataObjectChange(OID trackedObjectOID) {
        Assert.exists(trackedObjectOID, class$com$arsdigita$persistence$OID == null ? (class$com$arsdigita$persistence$OID = DataObjectChange.class$("com.arsdigita.persistence.OID")) : class$com$arsdigita$persistence$OID);
        this.m_dobj = SessionManager.getSession().create("com.arsdigita.versioning.DataObjectChange");
        this.set("id", functions.nextSequenceValue());
        this.set("oid", Adapter.serialize(trackedObjectOID));
        this.m_isRecoverable = ObjectTypeMetadata.getInstance().isRecoverable(trackedObjectOID.getObjectType().getQualifiedName());
        if (this.m_isRecoverable) {
            this.m_pending = new LinkedList();
        }
    }

    public void setTxn(DataObject txn) {
        this.set("txn", txn);
    }

    private void set(String property, Object value) {
        this.m_dobj.set(property, value);
    }

    private Object get(String property) {
        return this.m_dobj.get(property);
    }

    DataObject getDataObject() {
        return this.m_dobj;
    }

    void recordEvent(AddEvent ev) {
        this.recordAssocEvent(ev, EventType.ADD);
    }

    void recordEvent(RemoveEvent ev) {
        this.recordAssocEvent(ev, EventType.REMOVE);
    }

    private static boolean shouldSkip(String attrName) {
        if (attrName.startsWith("~")) {
            return true;
        }
        return attrName.indexOf("@link") != -1;
    }

    private void recordAssocEvent(PropertyEvent ev, EventType eventType) {
        String attrName = ev.getProperty().getName();
        if (DataObjectChange.shouldSkip(attrName)) {
            return;
        }
        OID value = ((DataObject)ev.getArgument()).getOID();
        String strValue = Adapter.serialize(value);
        DataObject operation = this.newOperation(strValue);
        operation.set("eventType", eventType.getDataObject());
        operation.set("attribute", attrName);
        operation.set("value", strValue);
        operation.set("javaclass", Types.OID.getDataObject());
        this.add("operations", operation);
    }

    private void add(String property, DataObject value) {
        ((DataAssociation)this.m_dobj.get(property)).add(value);
    }

    void recordEvent(SetEvent ev) {
        String attrName = ev.getProperty().getName();
        if (DataObjectChange.shouldSkip(attrName)) {
            return;
        }
        if (ev.getProperty().getContainer().getKeyProperties().contains(ev.getProperty())) {
            return;
        }
        if (this.m_isRecoverable) {
            if (ev.getArgument() != null) {
                this.m_pending.clear();
                return;
            }
            this.m_pending.add(ev);
        } else {
            this.record(ev);
        }
    }

    void record(SetEvent ev) {
        Object prevValue = ev.getPreviousValue();
        if (ev.getProperty().getType().isCompound() && prevValue != null) {
            prevValue = ((DataObject)prevValue).getOID();
        }
        Types type = Types.getObjectType(prevValue);
        Object value = null;
        DataObject operation = null;
        if (type == Types.BLOB) {
            value = prevValue;
            operation = this.newBlobOperation();
        } else {
            value = Adapter.serialize(prevValue);
            operation = this.newOperation((String)value);
        }
        operation.set("eventType", EventType.SET.getDataObject());
        operation.set("attribute", ev.getProperty().getName());
        operation.set("value", value);
        operation.set("javaclass", type.getDataObject());
        this.add("operations", operation);
    }

    void recordEvent(CreateEvent ev) {
        OID value = ((DataObject)ev.getObject()).getOID();
        String strValue = Adapter.serialize(value);
        DataObject operation = this.newOperation(strValue);
        operation.set("eventType", EventType.CREATE.getDataObject());
        operation.set("attribute", value.getObjectType().getQualifiedName());
        operation.set("value", strValue);
        operation.set("javaclass", Types.OID.getDataObject());
        this.add("operations", operation);
    }

    void recordEvent(DeleteEvent ev) {
        if (this.m_isRecoverable) {
            Iterator ii = this.m_pending.iterator();
            while (ii.hasNext()) {
                SetEvent sev = (SetEvent)ii.next();
                this.record(sev);
            }
            this.m_pending = null;
        }
        DataObject deletedObj = (DataObject)ev.getObject();
        String strValue = Adapter.serialize(deletedObj.getOID());
        DataObject operation = this.newOperation(strValue);
        operation.set("eventType", EventType.DELETE.getDataObject());
        operation.set("attribute", deletedObj.getOID().getObjectType().getQualifiedName());
        operation.set("value", strValue);
        operation.set("javaclass", Types.OID.getDataObject());
        this.add("operations", operation);
    }

    private DataObject newOperation(String str) {
        if (DbHelper.varcharLength(str) <= 4000) {
            return this.operation(Constants.GENERIC_OPERATION);
        }
        return this.operation(Constants.CLOB_OPERATION);
    }

    private DataObject newBlobOperation() {
        return this.operation(Constants.BLOB_OPERATION);
    }

    private DataObject operation(OpType opType) {
        DataObject dobj = SessionManager.getSession().create(opType.datatype());
        dobj.set("id", functions.nextSequenceValue());
        dobj.set("changeset", this.m_dobj);
        dobj.set("subtype", opType.integerValue());
        return dobj;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

