/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util.parameter;

import com.arsdigita.util.Assert;
import com.arsdigita.util.UncheckedWrapperException;
import com.arsdigita.util.parameter.ErrorList;
import com.arsdigita.util.parameter.MapParameter;
import com.arsdigita.util.parameter.Parameter;
import com.arsdigita.util.parameter.ParameterContext;
import com.arsdigita.util.parameter.ParameterInfo;
import com.arsdigita.util.parameter.ParameterReader;
import com.arsdigita.util.parameter.ParameterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.Logger;

public abstract class AbstractParameterContext
implements ParameterContext {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/util/parameter/AbstractParameterContext.java#8 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$util$parameter$AbstractParameterContext == null ? (class$com$arsdigita$util$parameter$AbstractParameterContext = AbstractParameterContext.class$("com.arsdigita.util.parameter.AbstractParameterContext")) : class$com$arsdigita$util$parameter$AbstractParameterContext));
    private final MapParameter m_param = new MapParameter("root");
    private final HashMap m_map = new HashMap();
    private final Properties m_info = new Properties();
    static /* synthetic */ Class class$com$arsdigita$util$parameter$AbstractParameterContext;
    static /* synthetic */ Class class$com$arsdigita$util$parameter$Parameter;
    static /* synthetic */ Class class$com$arsdigita$util$parameter$ParameterReader;
    static /* synthetic */ Class class$com$arsdigita$util$parameter$ErrorList;

    public final void register(Parameter param) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Registering " + param + " on " + this));
        }
        if (Assert.isEnabled()) {
            Assert.exists(param, class$com$arsdigita$util$parameter$Parameter == null ? (class$com$arsdigita$util$parameter$Parameter = AbstractParameterContext.class$("com.arsdigita.util.parameter.Parameter")) : class$com$arsdigita$util$parameter$Parameter);
            Assert.truth(!this.m_param.contains(param), param + " is already registered");
        }
        this.m_param.add(param);
    }

    public final Parameter[] getParameters() {
        ArrayList list = new ArrayList();
        Iterator params = this.m_param.iterator();
        while (params.hasNext()) {
            list.add(params.next());
        }
        return list.toArray(new Parameter[list.size()]);
    }

    public Object get(Parameter param) {
        return this.get(param, param.getDefaultValue());
    }

    public Object get(Parameter param, Object dephault) {
        Object value;
        if (Assert.isEnabled()) {
            Assert.exists(param, class$com$arsdigita$util$parameter$Parameter == null ? (class$com$arsdigita$util$parameter$Parameter = AbstractParameterContext.class$("com.arsdigita.util.parameter.Parameter")) : class$com$arsdigita$util$parameter$Parameter);
            Assert.truth(this.m_param.contains(param), param + " has not been registered");
        }
        if ((value = this.m_map.get(param)) == null) {
            return dephault;
        }
        return value;
    }

    public void set(Parameter param, Object value) {
        if (s_log.isDebugEnabled()) {
            s_log.debug((Object)("Setting " + param + " to " + value));
        }
        Assert.exists(param, class$com$arsdigita$util$parameter$Parameter == null ? (class$com$arsdigita$util$parameter$Parameter = AbstractParameterContext.class$("com.arsdigita.util.parameter.Parameter")) : class$com$arsdigita$util$parameter$Parameter);
        this.m_map.put(param, value);
    }

    public final ErrorList load(ParameterReader reader) {
        ErrorList errors = new ErrorList();
        this.load(reader, errors);
        return errors;
    }

    public final void load(ParameterReader reader, ErrorList errors) {
        if (Assert.isEnabled()) {
            Assert.exists(reader, class$com$arsdigita$util$parameter$ParameterReader == null ? (class$com$arsdigita$util$parameter$ParameterReader = AbstractParameterContext.class$("com.arsdigita.util.parameter.ParameterReader")) : class$com$arsdigita$util$parameter$ParameterReader);
            Assert.exists(errors, class$com$arsdigita$util$parameter$ErrorList == null ? (class$com$arsdigita$util$parameter$ErrorList = AbstractParameterContext.class$("com.arsdigita.util.parameter.ErrorList")) : class$com$arsdigita$util$parameter$ErrorList);
        }
        this.m_map.putAll((Map)this.m_param.read(reader, errors));
    }

    public final ErrorList validate() {
        ErrorList errors = new ErrorList();
        this.m_param.validate(this.m_map, errors);
        return errors;
    }

    public final void validate(ErrorList errors) {
        Assert.exists(errors, class$com$arsdigita$util$parameter$ErrorList == null ? (class$com$arsdigita$util$parameter$ErrorList = AbstractParameterContext.class$("com.arsdigita.util.parameter.ErrorList")) : class$com$arsdigita$util$parameter$ErrorList);
        this.m_param.validate(this.m_map, errors);
    }

    public final void save(ParameterWriter writer) {
        this.m_param.write(writer, this.m_map);
    }

    protected final void loadInfo() {
        InputStream in = AbstractParameterContext.findInfo(this.getClass());
        try {
            this.m_info.load(in);
        }
        catch (IOException ioe) {
            throw new UncheckedWrapperException(ioe);
        }
        Iterator params = this.m_param.iterator();
        while (params.hasNext()) {
            Parameter param = (Parameter)params.next();
            param.setInfo(new Info(param));
        }
    }

    private static InputStream findInfo(Class klass) {
        LinkedList files = new LinkedList();
        InputStream in = AbstractParameterContext.findInfo(klass, files);
        if (in == null) {
            throw new IllegalStateException("Could not find any of the following files: " + files);
        }
        return in;
    }

    private static InputStream findInfo(Class klass, List files) {
        if (klass == null) {
            return null;
        }
        String name = klass.getName().replace('.', '/') + "_parameter.properties";
        files.add(name);
        if (klass.getClassLoader() == null) {
            return null;
        }
        InputStream in = klass.getClassLoader().getResourceAsStream(name);
        if (in == null) {
            return AbstractParameterContext.findInfo(klass.getSuperclass(), files);
        }
        return in;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Info
    implements ParameterInfo {
        private final String m_name;

        Info(Parameter param) {
            this.m_name = param.getName();
        }

        public final String getTitle() {
            return AbstractParameterContext.this.m_info.getProperty(this.m_name + ".title");
        }

        public final String getPurpose() {
            return AbstractParameterContext.this.m_info.getProperty(this.m_name + ".purpose");
        }

        public final String getExample() {
            return AbstractParameterContext.this.m_info.getProperty(this.m_name + ".example");
        }

        public final String getFormat() {
            return AbstractParameterContext.this.m_info.getProperty(this.m_name + ".format");
        }
    }
}

