/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.util;

import com.arsdigita.util.UncheckedWrapperException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;

public final class Encoding {
    private static final String PADDING = "0x";
    private static final int PAD_LEN = "0x".length();
    private static final ByteArrayInputStream BAIS = new ByteArrayInputStream(new byte[]{0});

    private Encoding() {
    }

    public static String toHex(char ch) {
        return Encoding.pad(Encoding.toHex((int)ch), 4);
    }

    public static String toHex(byte b) {
        int num = b >= 0 ? b : b + 256;
        return Encoding.pad(Encoding.toHex(num), 2);
    }

    public static boolean isSupportedEncoding(String enc) {
        try {
            new InputStreamReader((InputStream)BAIS, enc);
            return true;
        }
        catch (UnsupportedEncodingException ex) {
            return false;
        }
    }

    public static byte[] getBytes(char ch, String enc) {
        if (enc == null) {
            throw new NullPointerException("enc");
        }
        try {
            byte[] result = String.valueOf(ch).getBytes(enc);
            if ("UTF-16".equals(enc.toUpperCase()) || "UTF16".equals(enc.toUpperCase())) {
                return Encoding.subarray(result, 2);
            }
            return result;
        }
        catch (UnsupportedEncodingException ex) {
            throw new UnsupportedException(enc, ex);
        }
    }

    private static byte[] subarray(byte[] array, int start) {
        if (start < 0 || start >= array.length) {
            throw new IllegalArgumentException("array.length=" + array.length + "; start=" + start);
        }
        byte[] result = new byte[array.length - start];
        for (int ii = 0; ii < array.length - start; ++ii) {
            result[ii] = array[start + ii];
        }
        return result;
    }

    private static String toHex(int num) {
        return Integer.toHexString(num).toUpperCase();
    }

    private static String pad(String hex, int width) {
        int bufLen = width + PAD_LEN;
        StringBuffer result = new StringBuffer(bufLen);
        result.append(PADDING);
        int len = hex.length();
        if (len >= width) {
            return result.append(hex).toString();
        }
        result.setLength(PAD_LEN + width - len);
        for (int ii = PAD_LEN; ii < PAD_LEN + width - len; ++ii) {
            result.setCharAt(ii, '0');
        }
        result.append(hex);
        return result.toString();
    }

    public static class UnsupportedException
    extends UncheckedWrapperException {
        public UnsupportedException(String msg) {
            super(msg);
        }

        public UnsupportedException(String msg, Throwable cause) {
            super(msg, cause);
        }

        public UnsupportedException(Throwable cause) {
            super(cause);
        }
    }
}

