/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.ui.permissions.PermissionStatus;
import com.arsdigita.ui.permissions.UserObjectStruct;
import java.math.BigDecimal;

final class UserPrivilegeKey {
    String m_objectID;
    String m_granteeID;
    String m_privilege;
    byte m_granted;

    public UserPrivilegeKey(BigDecimal objectID, BigDecimal granteeID, String privilege, boolean granted) {
        this.m_objectID = objectID.toString();
        this.m_granteeID = granteeID.toString();
        this.m_privilege = privilege;
        this.m_granted = granted ? (byte)1 : 0;
    }

    public String toString() {
        return this.m_privilege + "." + this.m_objectID + "." + this.m_granteeID + "." + this.m_granted;
    }

    static PermissionStatus undescribe(String key) {
        int i = key.indexOf(".");
        int j = key.indexOf(".", i + 1);
        int k = key.lastIndexOf(".");
        String privilege = key.substring(0, i);
        BigDecimal oID = new BigDecimal(key.substring(i + 1, j));
        BigDecimal gID = new BigDecimal(key.substring(j + 1, k));
        byte granted = 0;
        UserObjectStruct uos = null;
        try {
            granted = Byte.parseByte(key.substring(k + 1, k + 2));
            uos = new UserObjectStruct(gID, oID);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException(nfe.getMessage());
        }
        return new PermissionStatus(PrivilegeDescriptor.get(privilege), uos.getObject(), uos.getParty(), granted);
    }
}

