/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.ui.permissions;

import com.arsdigita.bebop.BoxPanel;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormData;
import com.arsdigita.bebop.FormProcessException;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SegmentedPanel;
import com.arsdigita.bebop.event.FormSectionEvent;
import com.arsdigita.bebop.event.FormSubmissionListener;
import com.arsdigita.bebop.event.PrintEvent;
import com.arsdigita.bebop.event.PrintListener;
import com.arsdigita.bebop.form.CheckboxGroup;
import com.arsdigita.bebop.form.Option;
import com.arsdigita.bebop.form.Submit;
import com.arsdigita.bebop.parameters.ArrayParameter;
import com.arsdigita.bebop.parameters.StringParameter;
import com.arsdigita.kernel.permissions.PermissionDescriptor;
import com.arsdigita.kernel.permissions.PermissionService;
import com.arsdigita.kernel.permissions.PrivilegeDescriptor;
import com.arsdigita.persistence.DataQuery;
import com.arsdigita.persistence.Filter;
import com.arsdigita.persistence.SessionManager;
import com.arsdigita.ui.permissions.PermissionsConstants;
import com.arsdigita.ui.permissions.PermissionsPane;
import com.arsdigita.ui.permissions.UserObjectStruct;
import com.arsdigita.util.StringUtils;
import com.arsdigita.util.UncheckedWrapperException;
import java.math.BigDecimal;
import java.util.TooManyListenersException;

class PermissionsGrant
implements PermissionsConstants {
    private static final String PARTIES_CBG = "parties_cbg";
    private static final String PRIVILEGES_CBG = "privs_cbg";
    private static final String USER_ID = "userID";
    private static final String FIRST_NAME = "firstName";
    private static final String LAST_NAME = "lastName";
    private SegmentedPanel m_grantPanel;
    private PermissionsPane m_parent;
    private CheckboxGroup m_parties;
    private CheckboxGroup m_privileges;
    private Form m_form;
    private Submit m_save;

    public PermissionsGrant(PermissionsPane parent) {
        this.m_parent = parent;
        this.makeForm();
        this.m_grantPanel = new SegmentedPanel();
        this.m_grantPanel.addSegment(new Label(PermissionsConstants.PAGE_GRANT_TITLE), (Component)this.m_form);
    }

    private void makeForm() {
        this.m_form = new Form("GrantPrivileges", new BoxPanel());
        this.m_form.setMethod("post");
        this.m_form.addSubmissionListener(new GrantFormSubmissionListener());
        this.m_form.add(new Label(PermissionsConstants.PAGE_GRANT_LEFT));
        this.m_parties = new CheckboxGroup(PARTIES_CBG);
        try {
            this.m_parties.addPrintListener(new UserSearchPrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException(e.getMessage(), e);
        }
        this.m_form.add(this.m_parties);
        this.m_form.add(new Label(PermissionsConstants.PAGE_GRANT_RIGHT));
        this.m_privileges = new CheckboxGroup(PRIVILEGES_CBG);
        try {
            this.m_privileges.addPrintListener(new PrivilegePrintListener());
        }
        catch (TooManyListenersException e) {
            throw new UncheckedWrapperException(e.getMessage(), e);
        }
        this.m_form.add(this.m_privileges);
        this.m_save = new Submit("save", PermissionsConstants.SAVE_BUTTON);
        this.m_form.add(this.m_save);
    }

    public SegmentedPanel getPanel() {
        return this.m_grantPanel;
    }

    private static class PrivilegePrintListener
    implements PrintListener {
        private PrivilegePrintListener() {
        }

        public void prepare(PrintEvent e) {
            PageState state = e.getPageState();
            CheckboxGroup cbg = (CheckboxGroup)e.getTarget();
            Object[] pa = (Object[])state.getValue(new ArrayParameter("privs_set"));
            for (int i = 0; i < pa.length; ++i) {
                cbg.addOption(new Option((String)pa[i], (String)pa[i]));
            }
        }
    }

    private class UserSearchPrintListener
    implements PrintListener {
        private UserSearchPrintListener() {
        }

        public void prepare(PrintEvent e) {
            PageState state = e.getPageState();
            CheckboxGroup cbg = (CheckboxGroup)e.getTarget();
            String search = (String)state.getValue(new StringParameter("query"));
            search = StringUtils.stripWhiteSpace(search);
            DataQuery query = SessionManager.getSession().retrieveQuery("com.arsdigita.kernel.RetrieveUsers");
            query.setParameter("excludeGroupId", null);
            Filter f = query.addFilter("searchName like lower('%' || :searchQuery || '%')");
            f.set("searchQuery", search);
            while (query.next()) {
                String userID = query.get(PermissionsGrant.USER_ID).toString();
                String userName = query.get(PermissionsGrant.FIRST_NAME) + " " + query.get(PermissionsGrant.LAST_NAME);
                cbg.addOption(new Option(userID, userName));
            }
            query.close();
        }
    }

    private class GrantFormSubmissionListener
    implements FormSubmissionListener {
        private GrantFormSubmissionListener() {
        }

        public void submitted(FormSectionEvent e) throws FormProcessException {
            PageState state = e.getPageState();
            FormData data = e.getFormData();
            String[] gids = (String[])data.get(PermissionsGrant.PARTIES_CBG);
            String[] privs = (String[])data.get(PermissionsGrant.PRIVILEGES_CBG);
            if (privs != null && gids != null) {
                BigDecimal oID = PermissionsGrant.this.m_parent.getObject(state).getID();
                BigDecimal gID = null;
                UserObjectStruct uos = null;
                PermissionDescriptor pmd = null;
                for (int j = 0; j < gids.length; ++j) {
                    gID = new BigDecimal(gids[j]);
                    uos = new UserObjectStruct(gID, oID);
                    for (int k = 0; k < privs.length; ++k) {
                        pmd = new PermissionDescriptor(PrivilegeDescriptor.get(privs[k]), uos.getObject(), uos.getParty());
                        PermissionService.grantPermission(pmd);
                    }
                }
            }
            PermissionsGrant.this.m_parent.showAdmin(state);
        }
    }
}

