/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.Form;
import com.arsdigita.bebop.FormSection;
import com.arsdigita.bebop.Label;
import com.arsdigita.bebop.List;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.Resettable;
import com.arsdigita.bebop.SingleSelectionModel;
import com.arsdigita.bebop.Tree;
import com.arsdigita.bebop.event.ChangeEvent;
import com.arsdigita.bebop.event.ChangeListener;
import com.arsdigita.bebop.list.ListModelBuilder;
import com.arsdigita.bebop.tree.TreeModelBuilder;
import com.arsdigita.globalization.GlobalizedMessage;
import com.arsdigita.toolbox.ui.ActionGroup;
import com.arsdigita.toolbox.ui.LayoutPanel;
import com.arsdigita.toolbox.ui.ModalPanel;
import com.arsdigita.toolbox.ui.NullComponent;
import com.arsdigita.toolbox.ui.Section;
import com.arsdigita.util.Assert;
import org.apache.log4j.Logger;

public class SelectionPanel
extends LayoutPanel
implements Resettable {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/SelectionPanel.java#19 $$Author: dennis $$DateTime: 2004/04/07 16:07:11 $";
    private static final Logger s_log = Logger.getLogger((Class)(class$com$arsdigita$toolbox$ui$SelectionPanel == null ? (class$com$arsdigita$toolbox$ui$SelectionPanel = SelectionPanel.class$("com.arsdigita.toolbox.ui.SelectionPanel")) : class$com$arsdigita$toolbox$ui$SelectionPanel));
    private SingleSelectionModel m_model;
    private Component m_selector;
    private ActionGroup m_group;
    private final ModalPanel m_body = new ModalPanel();
    private Component m_introPane;
    private Component m_itemPane;
    private ActionLink m_addLink;
    private Form m_addForm;
    private ActionLink m_editLink;
    private Form m_editForm;
    private ActionLink m_deleteLink;
    private Form m_deleteForm;
    static /* synthetic */ Class class$com$arsdigita$toolbox$ui$SelectionPanel;
    static /* synthetic */ Class class$com$arsdigita$bebop$Component;

    protected void build(Component title, Component selector, SingleSelectionModel model) {
        this.m_model = model;
        this.m_selector = selector;
        Section section = new Section();
        this.setLeft(section);
        section.setHeading(title);
        this.m_group = new ActionGroup();
        section.setBody(this.m_group);
        this.m_group.setSubject(selector);
    }

    protected SelectionPanel() {
        this.setBody(this.m_body);
        this.m_introPane = new NullComponent();
        this.m_body.add(this.m_introPane);
        this.m_body.setDefault(this.m_introPane);
        this.m_itemPane = new NullComponent();
        this.m_body.add(this.m_itemPane);
        this.m_addLink = null;
        this.m_addForm = null;
        this.m_editLink = null;
        this.m_editForm = null;
        this.m_deleteLink = null;
        this.m_deleteForm = null;
    }

    public SelectionPanel(Component title, Component selector) {
        this();
        if (Assert.isEnabled()) {
            Assert.exists(title, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = SelectionPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
            Assert.exists(selector, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = SelectionPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
            Assert.truth(selector instanceof Tree || selector instanceof List);
        }
        if (selector instanceof List) {
            List list = (List)selector;
            list.addChangeListener(new SelectionListener());
            this.build(title, list, list.getSelectionModel());
        } else {
            Tree tree = (Tree)selector;
            tree.addChangeListener(new SelectionListener());
            this.build(title, tree, tree.getSelectionModel());
        }
    }

    public SelectionPanel(Component title, Component selector, SingleSelectionModel model) {
        this();
        if (Assert.isEnabled()) {
            Assert.exists(title, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = SelectionPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
            Assert.exists(selector, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = SelectionPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
        }
        this.build(title, selector, model);
    }

    public SelectionPanel(GlobalizedMessage title, Component selector) {
        this((Component)new Label(title), selector);
    }

    public SelectionPanel(GlobalizedMessage title, Component selector, SingleSelectionModel model) {
        this(new Label(title), selector, model);
    }

    public SelectionPanel(Component title, TreeModelBuilder builder) {
        this(title, (Component)new Tree(builder));
    }

    public SelectionPanel(GlobalizedMessage title, TreeModelBuilder builder) {
        this((Component)new Label(title), builder);
    }

    public SelectionPanel(Component title, ListModelBuilder builder) {
        this(title, (Component)new List(builder));
    }

    public SelectionPanel(GlobalizedMessage title, ListModelBuilder builder) {
        this((Component)new Label(title), builder);
    }

    public void reset(PageState state) {
        s_log.debug((Object)"Resetting to default initial state");
        if (this.m_selector instanceof Resettable) {
            ((Resettable)((Object)this.m_selector)).reset(state);
        } else {
            this.m_model.clearSelection(state);
        }
    }

    public final void addAction(Component action) {
        this.m_group.addAction(action);
    }

    public final void addAction(Component action, String clacc) {
        this.m_group.addAction(action, clacc);
    }

    public final Component getSelector() {
        return this.m_selector;
    }

    protected final void setSelector(Component selector) {
        this.m_selector = selector;
    }

    public final void setSelectionModel(SingleSelectionModel model) {
        this.m_model = model;
    }

    public final SingleSelectionModel getSelectionModel() {
        return this.m_model;
    }

    public final ActionLink getAddLink() {
        return this.m_addLink;
    }

    public final Form getAddForm() {
        return this.m_addForm;
    }

    public final void setAdd(GlobalizedMessage message, Form form) {
        this.setAdd(new ActionLink(new Label(message)), form);
    }

    public final void setAdd(ActionLink addLink, Form form) {
        Assert.assertNotNull(addLink, "ActionLink addLink");
        Assert.assertNotNull(form, "Form form");
        Assert.assertNotLocked(this);
        this.m_addForm = form;
        this.m_body.add(this.m_addForm);
        this.m_addLink = addLink;
        this.m_body.connect(this.m_addLink, (FormSection)this.m_addForm);
    }

    public final ActionLink getEditLink() {
        return this.m_editLink;
    }

    public final Form getEditForm() {
        return this.m_editForm;
    }

    public final void setEdit(GlobalizedMessage message, Form form) {
        this.setEdit(new ActionLink(new Label(message)), form);
    }

    public final void setEdit(ActionLink editLink, Form form) {
        Assert.assertNotNull(editLink, "ActionLink editLink");
        Assert.assertNotNull(form, "Form form");
        Assert.assertNotLocked(this);
        this.m_editForm = form;
        this.m_body.add(this.m_editForm);
        this.m_editLink = editLink;
        this.m_body.connect(this.m_editLink, (FormSection)this.m_editForm);
        this.m_body.connect(this.m_editForm);
    }

    public final ActionLink getDeleteLink() {
        return this.m_deleteLink;
    }

    public final Form getDeleteForm() {
        return this.m_deleteForm;
    }

    public final void setDelete(GlobalizedMessage message, Form form) {
        this.setDelete(new ActionLink(new Label(message)), form);
    }

    public final void setDelete(ActionLink deleteLink, Form form) {
        Assert.assertNotNull(deleteLink, "ActionLink deleteLink");
        Assert.assertNotNull(form, "Form form");
        Assert.assertNotLocked(this);
        this.m_deleteForm = form;
        this.m_body.add(this.m_deleteForm);
        this.m_deleteLink = deleteLink;
        this.m_body.connect(this.m_deleteLink, (FormSection)this.m_deleteForm);
    }

    public final ModalPanel getBody() {
        return this.m_body;
    }

    public final Component getIntroPane() {
        return this.m_introPane;
    }

    public final void setIntroPane(Component pane) {
        Assert.exists(pane, class$com$arsdigita$bebop$Component == null ? (class$com$arsdigita$bebop$Component = SelectionPanel.class$("com.arsdigita.bebop.Component")) : class$com$arsdigita$bebop$Component);
        Assert.unlocked(this);
        this.m_introPane = pane;
        this.m_body.add(this.m_introPane);
        this.m_body.setDefault(this.m_introPane);
    }

    public final Component getItemPane() {
        return this.m_itemPane;
    }

    public final void setItemPane(Component pane) {
        Assert.assertNotNull(pane, "Component pane");
        Assert.assertNotLocked(this);
        this.m_itemPane = pane;
        this.m_body.add(this.m_itemPane);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public class SelectionListener
    implements ChangeListener {
        public final void stateChanged(ChangeEvent e) {
            s_log.debug((Object)"Selection state changed; I may change the body's visible pane");
            PageState state = e.getPageState();
            SelectionPanel.this.m_body.reset(state);
            if (SelectionPanel.this.m_model.isSelected(state)) {
                s_log.debug((Object)"The selection model is selected; displaying the item pane");
                SelectionPanel.this.m_body.push(state, SelectionPanel.this.m_itemPane);
            }
        }
    }
}

