/*
 * Decompiled with CFR 0.152.
 */
package com.arsdigita.toolbox.ui;

import com.arsdigita.bebop.ActionLink;
import com.arsdigita.bebop.Component;
import com.arsdigita.bebop.CompoundComponent;
import com.arsdigita.bebop.Page;
import com.arsdigita.bebop.PageState;
import com.arsdigita.bebop.SimpleContainer;
import com.arsdigita.bebop.event.ActionEvent;
import com.arsdigita.bebop.event.ActionListener;
import com.arsdigita.bebop.parameters.StringParameter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DimensionBar
extends CompoundComponent {
    public static final String versionId = "$Id: //core-platform/dev/src/com/arsdigita/toolbox/ui/DimensionBar.java#7 $ by $Author: dennis $, $DateTime: 2004/04/07 16:07:11 $";
    private Component m_title;
    private SimpleContainer m_links = new SimpleContainer();
    private StringParameter m_state = new StringParameter("dim");
    private Map m_active = new HashMap();
    private Map m_selectable = new HashMap();

    public DimensionBar(Component title) {
        super(new SimpleContainer("bebop:dimensionBar", "http://www.arsdigita.com/bebop/1.0"));
        this.m_title = title;
        this.m_title.setClassAttr("dimensionBarTitle");
        this.m_links.setClassAttr("dimensionBarOptions");
        this.add(this.m_title, 2);
        this.add(this.m_links, 2);
    }

    public void add(String key, Component c) {
        SimpleContainer active = new SimpleContainer();
        c.setClassAttr("dimensionBarOption");
        active.add(c);
        this.add(key, c, active);
    }

    public void add(final String key, Component selectable, Component active) {
        SimpleContainer cont = new SimpleContainer();
        selectable.setClassAttr("dimensionBarOption");
        ActionLink link = new ActionLink(selectable);
        link.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DimensionBar.this.dimClicked(evt.getPageState(), key);
            }
        });
        cont.add(link);
        cont.add(active);
        this.m_selectable.put(key, link);
        this.m_active.put(key, active);
        if (this.m_links.isEmpty()) {
            this.setDefaultKey(key);
        }
        this.m_links.add(cont);
    }

    private void dimClicked(PageState ps, String key) {
        Component c;
        ps.setValue(this.m_state, key);
        Iterator it = this.m_selectable.values().iterator();
        while (it.hasNext()) {
            c = (Component)it.next();
            c.setVisible(ps, true);
        }
        it = this.m_active.values().iterator();
        while (it.hasNext()) {
            c = (Component)it.next();
            c.setVisible(ps, false);
        }
        Component c2 = (Component)this.m_selectable.get(key);
        c2.setVisible(ps, false);
        c2 = (Component)this.m_active.get(key);
        c2.setVisible(ps, true);
    }

    public void setDefaultKey(String key) {
        this.m_state.setDefaultValue(key);
    }

    public String getDefaultKey() {
        return (String)this.m_state.getDefaultValue();
    }

    public String getSelectedKey(PageState ps) {
        return (String)ps.getValue(this.m_state);
    }

    public void setSelectedKey(PageState ps, String key) {
        ps.setValue(this.m_state, key);
        this.dimClicked(ps, key);
    }

    public void register(Page p) {
        Component c;
        super.register(p);
        p.addComponentStateParam(this, this.m_state);
        Iterator it = this.m_active.values().iterator();
        while (it.hasNext()) {
            c = (Component)it.next();
            p.setVisibleDefault(c, false);
        }
        String key = this.getDefaultKey();
        c = (Component)this.m_active.get(key);
        p.setVisibleDefault(c, true);
        c = (Component)this.m_selectable.get(key);
        p.setVisibleDefault(c, false);
    }
}

